/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzsu;
import com.google.android.gms.internal.zzsx;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzsn {
    private final ByteBuffer zzbui;

    private zzsn(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzsn(ByteBuffer byteBuffer) {
        this.zzbui = byteBuffer;
        this.zzbui.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzsn zzE(byte[] byArray) {
        return zzsn.zzb(byArray, 0, byArray.length);
    }

    public static zzsn zzb(byte[] byArray, int n, int n2) {
        return new zzsn(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzE(n, 1);
        this.zzk(d);
    }

    public void zzb(int n, float f) throws IOException {
        this.zzE(n, 5);
        this.zzj(f);
    }

    public void zza(int n, long l) throws IOException {
        this.zzE(n, 0);
        this.zzao(l);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzE(n, 0);
        this.zzap(l);
    }

    public void zzA(int n, int n2) throws IOException {
        this.zzE(n, 0);
        this.zzmv(n2);
    }

    public void zze(int n, boolean bl) throws IOException {
        this.zzE(n, 0);
        this.zzaz(bl);
    }

    public void zzn(int n, String string) throws IOException {
        this.zzE(n, 2);
        this.zzgN(string);
    }

    public void zza(int n, zzsu zzsu2) throws IOException {
        this.zzE(n, 2);
        this.zzc(zzsu2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzE(n, 2);
        this.zzF(byArray);
    }

    public void zzB(int n, int n2) throws IOException {
        this.zzE(n, 0);
        this.zzmw(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzE(n, 0);
        this.zzaq(l);
    }

    public void zzk(double d) throws IOException {
        this.zzaw(Double.doubleToLongBits(d));
    }

    public void zzj(float f) throws IOException {
        this.zzmD(Float.floatToIntBits(f));
    }

    public void zzao(long l) throws IOException {
        this.zzau(l);
    }

    public void zzap(long l) throws IOException {
        this.zzau(l);
    }

    public void zzmv(int n) throws IOException {
        if (n >= 0) {
            this.zzmB(n);
        } else {
            this.zzau(n);
        }
    }

    public void zzaz(boolean bl) throws IOException {
        this.zzmz(bl ? 1 : 0);
    }

    public void zzgN(String string) throws IOException {
        try {
            int n = zzsn.zzmC(string.length());
            int n2 = zzsn.zzmC(string.length() * 3);
            if (n == n2) {
                int n3 = this.zzbui.position();
                if (this.zzbui.remaining() < n) {
                    throw new zza(n3 + n, this.zzbui.limit());
                }
                this.zzbui.position(n3 + n);
                zzsn.zza((CharSequence)string, this.zzbui);
                int n4 = this.zzbui.position();
                this.zzbui.position(n3);
                this.zzmB(n4 - n3 - n);
                this.zzbui.position(n4);
            } else {
                this.zzmB(zzsn.zzc(string));
                zzsn.zza((CharSequence)string, this.zzbui);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.zzbui.position(), this.zzbui.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzc(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzsn.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzsn.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzsn.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            int n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                char c2;
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (n3 - 1));
                }
                int n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                if (!('\ud800' > c || c > '\udfff' || n3 + 1 != charSequence.length() && Character.isSurrogatePair(c, charSequence.charAt(n3 + 1)))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + n3);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzsu zzsu2) throws IOException {
        zzsu2.writeTo(this);
    }

    public void zzc(zzsu zzsu2) throws IOException {
        this.zzmB(zzsu2.getCachedSize());
        zzsu2.writeTo(this);
    }

    public void zzF(byte[] byArray) throws IOException {
        this.zzmB(byArray.length);
        this.zzH(byArray);
    }

    public void zzmw(int n) throws IOException {
        this.zzmB(zzsn.zzmE(n));
    }

    public void zzaq(long l) throws IOException {
        this.zzau(zzsn.zzax(l));
    }

    public static int zzb(int n, double d) {
        return zzsn.zzmA(n) + zzsn.zzl(d);
    }

    public static int zzc(int n, float f) {
        return zzsn.zzmA(n) + zzsn.zzk(f);
    }

    public static int zzd(int n, long l) {
        return zzsn.zzmA(n) + zzsn.zzas(l);
    }

    public static int zzC(int n, int n2) {
        return zzsn.zzmA(n) + zzsn.zzmx(n2);
    }

    public static int zzf(int n, boolean bl) {
        return zzsn.zzmA(n) + zzsn.zzaA(bl);
    }

    public static int zzo(int n, String string) {
        return zzsn.zzmA(n) + zzsn.zzgO(string);
    }

    public static int zzb(int n, zzsu zzsu2) {
        return zzsn.zzmA(n) * 2 + zzsn.zzd(zzsu2);
    }

    public static int zzc(int n, zzsu zzsu2) {
        return zzsn.zzmA(n) + zzsn.zze(zzsu2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzsn.zzmA(n) + zzsn.zzG(byArray);
    }

    public static int zzD(int n, int n2) {
        return zzsn.zzmA(n) + zzsn.zzmy(n2);
    }

    public static int zze(int n, long l) {
        return zzsn.zzmA(n) + zzsn.zzat(l);
    }

    public static int zzl(double d) {
        return 8;
    }

    public static int zzk(float f) {
        return 4;
    }

    public static int zzar(long l) {
        return zzsn.zzav(l);
    }

    public static int zzas(long l) {
        return zzsn.zzav(l);
    }

    public static int zzmx(int n) {
        if (n >= 0) {
            return zzsn.zzmC(n);
        }
        return 10;
    }

    public static int zzaA(boolean bl) {
        return 1;
    }

    public static int zzgO(String string) {
        int n = zzsn.zzc(string);
        return zzsn.zzmC(n) + n;
    }

    public static int zzd(zzsu zzsu2) {
        return zzsu2.getSerializedSize();
    }

    public static int zze(zzsu zzsu2) {
        int n = zzsu2.getSerializedSize();
        return zzsn.zzmC(n) + n;
    }

    public static int zzG(byte[] byArray) {
        return zzsn.zzmC(byArray.length) + byArray.length;
    }

    public static int zzmy(int n) {
        return zzsn.zzmC(zzsn.zzmE(n));
    }

    public static int zzat(long l) {
        return zzsn.zzav(zzsn.zzax(l));
    }

    public int zzJn() {
        return this.zzbui.remaining();
    }

    public void zzJo() {
        if (this.zzJn() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzb(byte by) throws IOException {
        if (!this.zzbui.hasRemaining()) {
            throw new zza(this.zzbui.position(), this.zzbui.limit());
        }
        this.zzbui.put(by);
    }

    public void zzmz(int n) throws IOException {
        this.zzb((byte)n);
    }

    public void zzH(byte[] byArray) throws IOException {
        this.zzc(byArray, 0, byArray.length);
    }

    public void zzc(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzbui.remaining() < n2) {
            throw new zza(this.zzbui.position(), this.zzbui.limit());
        }
        this.zzbui.put(byArray, n, n2);
    }

    public void zzE(int n, int n2) throws IOException {
        this.zzmB(zzsx.zzF(n, n2));
    }

    public static int zzmA(int n) {
        return zzsn.zzmC(zzsx.zzF(n, 0));
    }

    public void zzmB(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzmz(n);
                return;
            }
            this.zzmz(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzmC(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzau(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzmz((int)l);
                return;
            }
            this.zzmz((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzav(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzmD(int n) throws IOException {
        if (this.zzbui.remaining() < 4) {
            throw new zza(this.zzbui.position(), this.zzbui.limit());
        }
        this.zzbui.putInt(n);
    }

    public void zzaw(long l) throws IOException {
        if (this.zzbui.remaining() < 8) {
            throw new zza(this.zzbui.position(), this.zzbui.limit());
        }
        this.zzbui.putLong(l);
    }

    public static int zzmE(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzax(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + n + " limit " + n2 + ").");
        }
    }
}

