/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.internal.zzne;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.GetPermissionStatusRequest;
import com.google.android.gms.nearby.messages.internal.HandleClientLifecycleEventRequest;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.PublishRequest;
import com.google.android.gms.nearby.messages.internal.RegisterStatusCallbackRequest;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.UnpublishRequest;
import com.google.android.gms.nearby.messages.internal.UnsubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzd;
import com.google.android.gms.nearby.messages.internal.zzf;
import com.google.android.gms.nearby.messages.internal.zzg;
import com.google.android.gms.nearby.messages.internal.zzh;
import com.google.android.gms.nearby.messages.internal.zzi;
import com.google.android.gms.nearby.messages.internal.zzp;

class zzm
extends zzj<com.google.android.gms.nearby.messages.internal.zzf> {
    private final boolean zzbcv;
    private final ClientAppContext zzbcw;
    private final zzg<StatusCallback, zze> zzbcx = new zzg<StatusCallback, zze>(){

        protected zze zze(zzq<StatusCallback> zzq2) {
            return new zze(zzq2);
        }

        @Override
        protected /* synthetic */ zza zzf(zzq zzq2) {
            return this.zze((zzq<StatusCallback>)zzq2);
        }
    };
    private final zzg<MessageListener, zzc> zzbcy = new zzg<MessageListener, zzc>(){

        protected zzc zzg(zzq<MessageListener> zzq2) {
            return new zzc(zzq2);
        }

        @Override
        protected /* synthetic */ zza zzf(zzq zzq2) {
            return this.zzg((zzq<MessageListener>)zzq2);
        }
    };

    private static int zzaU(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzm(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zzf zzf2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzf2, connectionCallbacks, onConnectionFailedListener);
        String string = zzf2.zzqv();
        int n = zzm.zzaU(context);
        if (messagesOptions != null) {
            this.zzbcw = new ClientAppContext(string, messagesOptions.zzbbF, messagesOptions.zzbbH, n);
            this.zzbcv = messagesOptions.zzbbG;
        } else {
            this.zzbcw = new ClientAppContext(string, null, false, n);
            this.zzbcv = false;
        }
        if (n == 1 && zzne.zzsg()) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(activity, this));
        }
    }

    @NonNull
    protected String zzgu() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected String zzgv() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    protected com.google.android.gms.nearby.messages.internal.zzf zzdE(IBinder iBinder) {
        return zzf.zza.zzdA(iBinder);
    }

    public void disconnect() {
        try {
            this.zzjq(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        super.disconnect();
    }

    void zza(zza.zzb<Status> zzb2, MessageWrapper messageWrapper, PublishOptions publishOptions) throws RemoteException {
        PublishRequest publishRequest = new PublishRequest(messageWrapper, publishOptions.getStrategy(), (IBinder)zzp.zzn(zzb2), this.zzbcv, (IBinder)zzd.zza(publishOptions.getCallback()), this.zzbcw);
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(publishRequest);
    }

    void zza(zza.zzb<Status> zzb2, MessageWrapper messageWrapper) throws RemoteException {
        UnpublishRequest unpublishRequest = new UnpublishRequest(messageWrapper, (IBinder)zzp.zzn(zzb2), this.zzbcw);
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(unpublishRequest);
    }

    void zza(zza.zzb<Status> zzb2, zzq<MessageListener> zzq2, MessageListener messageListener, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest((IBinder)this.zzbcy.zza(zzq2, messageListener), subscribeOptions.getStrategy(), (IBinder)zzp.zzn(zzb2), subscribeOptions.getFilter(), null, 0, byArray, this.zzbcv, (IBinder)zzf.zza(subscribeOptions.getCallback()), this.zzbcw);
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(subscribeRequest);
    }

    void zza(zza.zzb<Status> zzb2, PendingIntent pendingIntent, SubscribeOptions subscribeOptions) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)zzp.zzn(zzb2), subscribeOptions.getFilter(), pendingIntent, 0, null, this.zzbcv, (IBinder)zzf.zza(subscribeOptions.getCallback()), this.zzbcw);
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(subscribeRequest);
    }

    void zza(zza.zzb<Status> zzb2, zzq<MessageListener> zzq2, MessageListener messageListener) throws RemoteException {
        if (this.zzbcy.zzG(messageListener) == null) {
            return;
        }
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest((IBinder)this.zzbcy.zza(zzq2, messageListener), (IBinder)zzp.zzn(zzb2), null, 0, this.zzbcw);
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(unsubscribeRequest);
        this.zzbcy.zzH(messageListener);
    }

    void zza(zza.zzb<Status> zzb2, PendingIntent pendingIntent) throws RemoteException {
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest(null, (IBinder)zzp.zzn(zzb2), pendingIntent, 0, this.zzbcw);
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(unsubscribeRequest);
    }

    void zzm(zza.zzb<Status> zzb2) throws RemoteException {
        GetPermissionStatusRequest getPermissionStatusRequest = new GetPermissionStatusRequest((IBinder)zzp.zzn(zzb2), this.zzbcw);
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(getPermissionStatusRequest);
    }

    void zza(zza.zzb<Status> zzb2, zzq<StatusCallback> zzq2, StatusCallback statusCallback) throws RemoteException {
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzp.zzn(zzb2), (IBinder)this.zzbcx.zza(zzq2, statusCallback), this.zzbcw);
        registerStatusCallbackRequest.zzbcX = true;
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(registerStatusCallbackRequest);
    }

    void zzb(zza.zzb<Status> zzb2, zzq<StatusCallback> zzq2, StatusCallback statusCallback) throws RemoteException {
        if (this.zzbcx.zzG(statusCallback) == null) {
            return;
        }
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzp.zzn(zzb2), (IBinder)this.zzbcx.zza(zzq2, statusCallback), this.zzbcw);
        registerStatusCallbackRequest.zzbcX = false;
        ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(registerStatusCallbackRequest);
        this.zzbcx.zzH(statusCallback);
    }

    void zzjq(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            HandleClientLifecycleEventRequest handleClientLifecycleEventRequest = new HandleClientLifecycleEventRequest(this.zzbcw, n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((com.google.android.gms.nearby.messages.internal.zzf)this.zzqJ()).zza(handleClientLifecycleEventRequest);
        } else {
            Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
        }
    }

    zzq<MessageListener> zza(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return zzm.zza(googleApiClient, messageListener, this.zzbcy);
    }

    zzq<StatusCallback> zza(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        return zzm.zza(googleApiClient, statusCallback, this.zzbcx);
    }

    private static <C> zzq<C> zza(GoogleApiClient googleApiClient, C c, zzg<C, ? extends zza<C>> zzg2) {
        zza<C> zza2 = zzg2.zzG(c);
        if (zza2 != null) {
            return zza2.zzEE();
        }
        return googleApiClient.zzr(c);
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzdE(iBinder);
    }

    private static abstract class zzg<C, W extends zza<C>> {
        private final SimpleArrayMap<C, W> zzanP = new SimpleArrayMap(1);

        private zzg() {
        }

        @Nullable
        W zzG(C c) {
            return (W)((zza)this.zzanP.get(c));
        }

        W zza(zzq<C> zzq2, C c) {
            zza<Object> zza2 = (zza)this.zzanP.get(c);
            if (zza2 != null) {
                zzq2.clear();
                return (W)zza2;
            }
            zza2 = this.zzf(zzq2);
            this.zzanP.put(c, (Object)zza2);
            return (W)zza2;
        }

        @Nullable
        W zzH(C c) {
            zza zza2 = (zza)this.zzanP.remove(c);
            if (zza2 != null) {
                zza2.zzEE().clear();
            }
            return (W)zza2;
        }

        protected abstract W zzf(zzq<C> var1);
    }

    @TargetApi(value=14)
    private static class zzb
    implements Application.ActivityLifecycleCallbacks {
        private final Activity zzbcA;
        private final zzm zzbcB;

        private zzb(Activity activity, zzm zzm2) {
            this.zzbcA = activity;
            this.zzbcB = zzm2;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity == this.zzbcA) {
                try {
                    this.zzbcB.zzjq(1);
                }
                catch (RemoteException remoteException) {
                    Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit ACTIVITY_STOPPED from ClientLifecycleSafetyNet for Activity %s: %s", new Object[]{activity.getPackageName(), remoteException}));
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity == this.zzbcA) {
                Log.v((String)"NearbyMessagesClient", (String)String.format("Unregistering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
                activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }
    }

    private static class zzd
    extends zzg.zza {
        private final PublishCallback zzbcG;

        private zzd(PublishCallback publishCallback) {
            this.zzbcG = publishCallback;
        }

        @Nullable
        private static zzd zza(@Nullable PublishCallback publishCallback) {
            return publishCallback == null ? null : new zzd(publishCallback);
        }

        @Override
        public void onExpired() {
            this.zzbcG.onExpired();
        }
    }

    private static class zzf
    extends zzi.zza {
        private final SubscribeCallback zzbcK;

        private zzf(SubscribeCallback subscribeCallback) {
            this.zzbcK = subscribeCallback;
        }

        @Nullable
        private static zzf zza(@Nullable SubscribeCallback subscribeCallback) {
            return subscribeCallback == null ? null : new zzf(subscribeCallback);
        }

        @Override
        public void onExpired() {
            this.zzbcK.onExpired();
        }
    }

    private static class zze
    extends zzh.zza
    implements zza<StatusCallback> {
        private final zzq<StatusCallback> zzbcH;

        private zze(zzq<StatusCallback> zzq2) {
            this.zzbcH = zzq2;
        }

        @Override
        public void onPermissionChanged(final boolean granted) {
            this.zzbcH.zza((zzq.zzb)new zzq.zzb<StatusCallback>(){

                public void zza(StatusCallback statusCallback) {
                    statusCallback.onPermissionChanged(granted);
                }

                public void zzpr() {
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((StatusCallback)object);
                }
            });
        }

        @Override
        public zzq<StatusCallback> zzEE() {
            return this.zzbcH;
        }
    }

    private static class zzc
    extends zzd.zza
    implements zza<MessageListener> {
        private final zzq<MessageListener> zzbbi;

        private zzc(zzq<MessageListener> zzq2) {
            this.zzbbi = zzq2;
        }

        @Override
        public void zza(final MessageWrapper messageWrapper) throws RemoteException {
            this.zzbbi.zza((zzq.zzb)new zzq.zzb<MessageListener>(){

                public void zza(MessageListener messageListener) {
                    messageListener.onFound(messageWrapper.zzbcu);
                }

                public void zzpr() {
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((MessageListener)object);
                }
            });
        }

        @Override
        public void zza(final MessageWrapper[] messageWrapperArray) throws RemoteException {
            this.zzbbi.zza((zzq.zzb)new zzq.zzb<MessageListener>(){

                public void zza(MessageListener messageListener) {
                    for (MessageWrapper messageWrapper : messageWrapperArray) {
                        messageListener.zza(messageWrapper.zzbcu);
                    }
                }

                public void zzpr() {
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((MessageListener)object);
                }
            });
        }

        @Override
        public void zzb(final MessageWrapper messageWrapper) throws RemoteException {
            this.zzbbi.zza((zzq.zzb)new zzq.zzb<MessageListener>(){

                public void zza(MessageListener messageListener) {
                    messageListener.onLost(messageWrapper.zzbcu);
                }

                public void zzpr() {
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((MessageListener)object);
                }
            });
        }

        @Override
        public zzq<MessageListener> zzEE() {
            return this.zzbbi;
        }
    }

    private static interface zza<C> {
        public zzq<C> zzEE();
    }
}

