/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageFilter;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.Strategy;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzm;
import java.util.List;

public class zzn
implements Messages {
    public static final Api.zzc<zzm> zzUI = new Api.zzc();
    public static final Api.zza<zzm, MessagesOptions> zzUJ = new Api.zza<zzm, MessagesOptions>(){

        public zzm zza(Context context, Looper looper, zzf zzf2, MessagesOptions messagesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzm(context, looper, connectionCallbacks, onConnectionFailedListener, zzf2, messagesOptions);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };

    @Override
    public PendingResult<Status> publish(GoogleApiClient client, final Message message, final PublishOptions options) {
        zzx.zzz((Object)message);
        zzx.zzz((Object)options);
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                MessageWrapper messageWrapper = MessageWrapper.zzb(message);
                zzm2.zza((zza.zzb<Status>)this, messageWrapper, options);
            }
        });
    }

    @Override
    @Deprecated
    public PendingResult<Status> publish(GoogleApiClient client, Message message, Strategy strategy) {
        return this.publish(client, message, new PublishOptions.Builder().setStrategy(strategy).build());
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient client, Message message) {
        return this.publish(client, message, PublishOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unpublish(GoogleApiClient client, final Message message) {
        zzx.zzz((Object)message);
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                MessageWrapper messageWrapper = MessageWrapper.zzb(message);
                zzm2.zza((zza.zzb<Status>)this, messageWrapper);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient client, final MessageListener listener, final SubscribeOptions options) {
        zzx.zzz((Object)listener);
        zzx.zzz((Object)options);
        final zzq<MessageListener> zzq2 = ((zzm)client.zza(zzUI)).zza(client, listener);
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                zzm2.zza((zza.zzb<Status>)this, (zzq<MessageListener>)zzq2, listener, options, null);
            }
        });
    }

    @Override
    @Deprecated
    public PendingResult<Status> subscribe(GoogleApiClient client, MessageListener listener, Strategy strategy, MessageFilter filter) {
        return this.subscribe(client, listener, new SubscribeOptions.Builder().setStrategy(strategy).setFilter(filter).build());
    }

    @Override
    @Deprecated
    public PendingResult<Status> subscribe(GoogleApiClient client, MessageListener listener, Strategy strategy) {
        return this.subscribe(client, listener, new SubscribeOptions.Builder().setStrategy(strategy).build());
    }

    @Override
    @Deprecated
    public PendingResult<Status> subscribe(GoogleApiClient client, MessageListener listener) {
        return this.subscribe(client, listener, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient client, final PendingIntent pendingIntent, final SubscribeOptions options) {
        zzx.zzz((Object)pendingIntent);
        zzx.zzz((Object)options);
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                zzm2.zza((zza.zzb<Status>)this, pendingIntent, options);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient client, PendingIntent pendingIntent) {
        return this.subscribe(client, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient client, final MessageListener listener) {
        zzx.zzz((Object)listener);
        final zzq<MessageListener> zzq2 = ((zzm)client.zza(zzUI)).zza(client, listener);
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                zzm2.zza((zza.zzb<Status>)this, (zzq<MessageListener>)zzq2, listener);
            }
        });
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient client, final PendingIntent pendingIntent) {
        zzx.zzz((Object)pendingIntent);
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                zzm2.zza((zza.zzb<Status>)this, pendingIntent);
            }
        });
    }

    @Override
    public void handleIntent(Intent intent, MessageListener messageListener) {
        Message message;
        Message message2 = zzn.zzA(intent);
        if (message2 != null) {
            messageListener.onFound(message2);
        }
        if ((message = zzn.zzB(intent)) != null) {
            messageListener.onLost(message);
        }
        for (Message message3 : zzn.zzC(intent)) {
            messageListener.zza(message3);
        }
    }

    @Nullable
    private static Message zzA(Intent intent) {
        return (Message)zzj.zzc(intent, "com.google.android.gms.nearby.messages.MESSAGES");
    }

    @Nullable
    private static Message zzB(Intent intent) {
        return (Message)zzj.zzc(intent, "com.google.android.gms.nearby.messages.LOST_MESSAGE");
    }

    private static List<Message> zzC(Intent intent) {
        return zzj.zzd(intent, "com.google.android.gms.nearby.messages.UPDATED_MESSAGES");
    }

    @Override
    public PendingResult<Status> getPermissionStatus(GoogleApiClient client) {
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                zzm2.zzm((zza.zzb<Status>)this);
            }
        });
    }

    @Override
    public PendingResult<Status> registerStatusCallback(GoogleApiClient client, final StatusCallback statusCallback) {
        zzx.zzz((Object)statusCallback);
        final zzq<StatusCallback> zzq2 = ((zzm)client.zza(zzUI)).zza(client, statusCallback);
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                zzm2.zza((zza.zzb<Status>)this, (zzq<StatusCallback>)zzq2, statusCallback);
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterStatusCallback(GoogleApiClient client, final StatusCallback statusCallback) {
        final zzq<StatusCallback> zzq2 = ((zzm)client.zza(zzUI)).zza(client, statusCallback);
        return client.zzb((zza.zza)new zza(client){

            protected void zza(zzm zzm2) throws RemoteException {
                zzm2.zzb((zza.zzb<Status>)this, (zzq<StatusCallback>)zzq2, statusCallback);
            }
        });
    }

    static abstract class zza
    extends zza.zza<Status, zzm> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzUI, googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }
}

