/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appinvite;

import android.accounts.Account;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzx;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public final class AppInviteInvitation {
    private static final String[] zzUK = new String[]{"jpg", "jpeg", "png"};

    private AppInviteInvitation() {
    }

    public static String[] getInvitationIds(int resultCode, @NonNull Intent result) {
        if (resultCode == -1) {
            return result.getStringArrayExtra("com.google.android.gms.appinvite.RESULT_INVITATION_IDS");
        }
        return null;
    }

    private static Bundle zzJ(Map<String, String> map) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            bundle.putString(string, map.get(string));
        }
        return bundle;
    }

    private static boolean zzbE(String string) {
        for (int i = 0; i < zzUK.length; ++i) {
            if (!zzUK[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final class IntentBuilder {
        public static final int MAX_MESSAGE_LENGTH = 100;
        public static final int MAX_EMAIL_HTML_CONTENT = 512000;
        public static final int MIN_CALL_TO_ACTION_TEXT_LENGTH = 2;
        public static final int MAX_CALL_TO_ACTION_TEXT_LENGTH = 20;
        private final Intent mIntent;
        private String zzUL;
        private String zzUM;

        public IntentBuilder(@NonNull CharSequence title) {
            zzx.zzz((Object)title);
            this.mIntent = new Intent("com.google.android.gms.appinvite.ACTION_APP_INVITE");
            this.mIntent.putExtra("com.google.android.gms.appinvite.TITLE", title);
            this.mIntent.setPackage("com.google.android.gms");
        }

        public IntentBuilder setAccount(Account account) {
            if (account != null && "com.google".equals(account.type)) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.ACCOUNT_NAME", (Parcelable)account);
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.ACCOUNT_NAME");
            }
            return this;
        }

        public IntentBuilder setMessage(CharSequence message) {
            if (message != null && message.length() > 100) {
                throw new IllegalArgumentException(String.format("Message must be %d chars or less.", 100));
            }
            this.mIntent.putExtra("com.google.android.gms.appinvite.MESSAGE", message);
            return this;
        }

        public IntentBuilder setEmailSubject(String subject) {
            this.zzUL = subject;
            return this;
        }

        public IntentBuilder setEmailHtmlContent(String htmlContent) {
            if (htmlContent != null && htmlContent.getBytes().length > 512000) {
                throw new IllegalArgumentException(String.format("Email html content must be %d bytes or less.", 512000));
            }
            this.zzUM = htmlContent;
            return this;
        }

        public IntentBuilder setDeepLink(Uri deepLink) {
            if (deepLink != null) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.DEEP_LINK_URL", (Parcelable)deepLink);
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.DEEP_LINK_URL");
            }
            return this;
        }

        public IntentBuilder setAdditionalReferralParameters(Map<String, String> params) {
            if (params != null) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.REFERRAL_PARAMETERS_URI", AppInviteInvitation.zzJ(params));
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.REFERRAL_PARAMETERS_URI");
            }
            return this;
        }

        public IntentBuilder setGoogleAnalyticsTrackingId(String trackingId) {
            this.mIntent.putExtra("com.google.android.gms.appinvite.GOOGLE_ANALYTICS_TRACKING_ID", trackingId);
            return this;
        }

        public IntentBuilder setAndroidMinimumVersionCode(int versionCode) {
            this.mIntent.putExtra("com.google.android.gms.appinvite.appMinimumVersionCode", versionCode);
            return this;
        }

        public IntentBuilder setCustomImage(Uri imageUri) {
            String string;
            zzx.zzz((Object)imageUri);
            zzx.zzb((boolean)imageUri.isAbsolute(), (Object)"Image uri is not an absolute uri. Did you forget to add a scheme to the Uri?");
            String string2 = imageUri.getScheme().toLowerCase();
            boolean bl = string2.equals("android.resource") || string2.equals("content") || string2.equals("file");
            zzx.zzb((bl || string2.equals("http") || string2.equals("https") ? 1 : 0) != 0, (Object)"Image uri must be a content URI with scheme \"android.resource\", \"content\" or \"file\", or a network url with scheme \"http\" or \"https\".");
            if (!bl) {
                string = imageUri.toString();
                String string3 = string.substring(string.lastIndexOf("/") + 1, string.length());
                String string4 = string3 == null ? null : (string3.lastIndexOf(".") == -1 ? null : string3.substring(string3.lastIndexOf(".") + 1, string3.length()).toLowerCase());
                zzx.zzb((TextUtils.isEmpty(string4) || AppInviteInvitation.zzbE(string4) ? 1 : 0) != 0, (Object)(string4 + " images are not supported. Only jpg, jpeg, or png images are" + " supported."));
            }
            string = imageUri.buildUpon().scheme(string2).build();
            this.mIntent.setData((Uri)string);
            if (bl) {
                this.mIntent.addFlags(1);
            }
            return this;
        }

        public IntentBuilder setCallToActionText(CharSequence callToActionText) {
            if (callToActionText == null || callToActionText.length() < 2 || callToActionText.length() > 20) {
                throw new IllegalArgumentException(String.format("Text must be between %d and %d chars in length.", 2, 20));
            }
            this.mIntent.putExtra("com.google.android.gms.appinvite.BUTTON_TEXT", callToActionText);
            return this;
        }

        public IntentBuilder setOtherPlatformsTargetApplication(int targetPlatform, String clientId) throws IllegalArgumentException {
            switch (targetPlatform) {
                case 1: {
                    this.mIntent.putExtra("com.google.android.gms.appinvite.iosTargetApplication", clientId);
                    break;
                }
                case 2: {
                    this.mIntent.putExtra("com.google.android.gms.appinvite.androidTargetApplication", clientId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("targetPlatform must be either PROJECT_PLATFORM_IOS or PROJECT_PLATFORM_ANDROID.");
                }
            }
            return this;
        }

        public Intent build() {
            if (!TextUtils.isEmpty((CharSequence)this.zzUL)) {
                zzx.zzh((String)this.zzUM, (Object)"Email html content must be set when email subject is set.");
                zzx.zzb((this.mIntent.getData() == null ? 1 : 0) != 0, (Object)"Custom image must not be set when email html content is set.");
                zzx.zzb((boolean)TextUtils.isEmpty((CharSequence)this.mIntent.getCharSequenceExtra("com.google.android.gms.appinvite.BUTTON_TEXT")), (Object)"Call to action text must not be set when email html content is set.");
                this.mIntent.putExtra("com.google.android.gms.appinvite.EMAIL_SUBJECT", this.zzUL);
                this.mIntent.putExtra("com.google.android.gms.appinvite.EMAIL_CONTENT", this.zzUM);
            } else if (!TextUtils.isEmpty((CharSequence)this.zzUM)) {
                throw new IllegalArgumentException("Email subject must be set when email html content is set.");
            }
            return this.mIntent;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PlatformMode {
            public static final int PROJECT_PLATFORM_IOS = 1;
            public static final int PROJECT_PLATFORM_ANDROID = 2;
        }
    }
}

