/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appinvite;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Iterator;

public class PreviewActivity
extends Activity {
    public static final String ACTION_PREVIEW = "com.google.android.gms.appinvite.ACTION_PREVIEW";
    public static final String EXTRA_LAYOUT_RES_ID = "com.google.android.gms.appinvite.LAYOUT_RES_ID";
    public static final String EXTRA_TABS = "com.google.android.gms.appinvite.TABS";
    public static final String KEY_TAB_TAG = "tabTag";
    public static final String KEY_TAB_CONTENT_ID = "tabContentId";
    public static final String EXTRA_VIEWS = "com.google.android.gms.appinvite.VIEWS";
    public static final String KEY_VIEW_ID = "View_id";
    public static final String KEY_VIEW_BACKGROUND_COLOR = "View_backgroundColor";
    public static final String KEY_VIEW_MIN_HEIGHT = "View_minHeight";
    public static final String KEY_VIEW_ON_CLICK_LISTENER = "View_onClickListener";
    public static final String KEY_TEXT_VIEW_TEXT = "TextView_text";
    public static final String KEY_TEXT_VIEW_IS_TITLE = "TextView_isTitle";
    public static final String KEY_TEXT_VIEW_TEXT_COLOR = "TextView_textColor";
    public static final String KEY_WEB_VIEW_DATA = "WebView_data";
    public static final String ON_CLICK_LISTENER_CLOSE = "close";

    protected void onCreate(Bundle savedInstanceState) {
        Context context;
        super.onCreate(savedInstanceState);
        if (this.getCallingActivity() == null || !"com.google.android.gms".equals(this.getCallingActivity().getPackageName())) {
            this.finish();
            return;
        }
        try {
            context = this.createPackageContext("com.google.android.gms", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.finish();
            return;
        }
        Bundle bundle = this.getIntent().getExtras();
        View view = this.zza(context, null, bundle);
        if (view == null) {
            this.finish();
            return;
        }
        TabHost tabHost = (TabHost)view.findViewById(0x1020012);
        TabWidget tabWidget = (TabWidget)view.findViewById(16908307);
        ArrayList arrayList = bundle.getParcelableArrayList(EXTRA_TABS);
        if (tabHost != null && tabWidget != null && arrayList != null) {
            tabHost.setup();
            for (Bundle bundle2 : arrayList) {
                TabHost.TabSpec tabSpec = tabHost.newTabSpec(bundle2.getString(KEY_TAB_TAG));
                tabSpec.setContent(bundle2.getInt(KEY_TAB_CONTENT_ID));
                View view2 = this.zza(context, (ViewGroup)tabWidget, bundle2);
                tabSpec.setIndicator(view2);
                tabHost.addTab(tabSpec);
            }
        }
        this.setContentView(view);
    }

    private View zza(Context context, ViewGroup viewGroup, Bundle bundle) {
        int n = bundle.getInt(EXTRA_LAYOUT_RES_ID);
        View view = LayoutInflater.from((Context)context).inflate(n, viewGroup, false);
        ArrayList arrayList = bundle.getParcelableArrayList(EXTRA_VIEWS);
        if (arrayList != null) {
            for (Bundle bundle2 : arrayList) {
                this.zza(view, bundle2);
            }
        }
        return view;
    }

    private void zza(View view, Bundle bundle) {
        View view2 = view.findViewById(bundle.getInt(KEY_VIEW_ID));
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            switch (string = (String)iterator.next()) {
                case "View_backgroundColor": {
                    view2.setBackgroundColor(bundle.getInt(string));
                    break;
                }
                case "View_minHeight": {
                    view2.setMinimumHeight(bundle.getInt(string));
                    break;
                }
                case "View_onClickListener": {
                    switch (bundle.getString(string)) {
                        case "close": {
                            view2.setOnClickListener(new View.OnClickListener(){

                                public void onClick(View view) {
                                    PreviewActivity.this.finish();
                                }
                            });
                        }
                    }
                    break;
                }
                case "TextView_text": {
                    if (!(view2 instanceof TextView)) break;
                    ((TextView)view2).setText(bundle.getCharSequence(string));
                    break;
                }
                case "TextView_textColor": {
                    if (!(view2 instanceof TextView)) break;
                    ((TextView)view2).setTextColor(bundle.getInt(string));
                    break;
                }
                case "TextView_isTitle": {
                    if (!(view2 instanceof TextView) || !bundle.getBoolean(string)) break;
                    this.setTitle(((TextView)view2).getText());
                    break;
                }
                case "WebView_data": {
                    if (!(view2 instanceof ViewGroup)) break;
                    String string2 = new WebView((Context)this);
                    string2.loadData(bundle.getString(string), "text/html; charset=utf-8", "UTF-8");
                    ((ViewGroup)view2).addView((View)string2, new ViewGroup.LayoutParams(-1, -1));
                }
            }
        }
    }
}

