/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzsu;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class UsageInfo
implements SafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int mVersionCode;
    final DocumentId zzUs;
    final long zzUt;
    int zzUu;
    public final String zzvp;
    final DocumentContents zzUv;
    final boolean zzUw;
    int zzUx;
    int zzUy;

    private UsageInfo(DocumentId documentId, long timestampMs, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this(1, documentId, timestampMs, usageType, query, document, isDeviceOnly, taskPosition, eventStatus);
    }

    public UsageInfo(String packageName, Intent viewIntent, String title, Uri webUrl, String schemaOrgType, List<AppIndexApi.AppIndexingLink> outLinks, int eventStatus) {
        this(1, UsageInfo.zza(packageName, viewIntent), System.currentTimeMillis(), 0, null, UsageInfo.zza(viewIntent, title, webUrl, schemaOrgType, outLinks).zzme(), false, -1, eventStatus);
    }

    UsageInfo(int versionCode, DocumentId documentId, long timestamp, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this.mVersionCode = versionCode;
        this.zzUs = documentId;
        this.zzUt = timestamp;
        this.zzUu = usageType;
        this.zzvp = query;
        this.zzUv = document;
        this.zzUw = isDeviceOnly;
        this.zzUx = taskPosition;
        this.zzUy = eventStatus;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzn(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzn(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzbD(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzap(1).zzN(true).zzbC("name").zzmh(), "text1");
    }

    private static DocumentSection zzi(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzap(4).zzM(true).zzbC("url").zzmh());
    }

    private static DocumentSection zzo(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzM(true).zzmh(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzs(List<AppIndexApi.AppIndexingLink> list) {
        zzpm.zza zza2 = new zzpm.zza();
        zzpm.zza.zza[] zzaArray = new zzpm.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzpm.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].zzaMq = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].zzaMr = appIndexingLink.webUrl.toString();
        }
        zza2.zzaMo = zzaArray;
        return new DocumentSection(zzsu.toByteArray((zzsu)zza2), new RegisterSectionInfo.zza("outlinks").zzM(true).zzbC(".private:outLinks").zzbB("blob").zzmh());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzbD(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzi(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzs(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzo("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzo("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzo("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzo("intent_extra_data", string3));
        }
        return zza2.zzbz(string2).zzL(true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", this.zzUs, this.zzUt, this.zzUu, this.zzUy);
    }

    public static final class zza {
        private DocumentId zzUs;
        private long zzUt = -1L;
        private int zzUu = -1;
        private String zzOJ;
        private DocumentContents zzUv;
        private boolean zzUw = false;
        private int zzUx = -1;
        private int zzUy = 0;

        public zza zza(DocumentId documentId) {
            this.zzUs = documentId;
            return this;
        }

        public zza zzw(long l) {
            this.zzUt = l;
            return this;
        }

        public zza zzar(int n) {
            this.zzUu = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.zzUv = documentContents;
            return this;
        }

        public zza zzO(boolean bl) {
            this.zzUw = bl;
            return this;
        }

        public zza zzas(int n) {
            this.zzUy = n;
            return this;
        }

        public UsageInfo zzmi() {
            return new UsageInfo(this.zzUs, this.zzUt, this.zzUu, this.zzOJ, this.zzUv, this.zzUw, this.zzUx, this.zzUy);
        }
    }
}

