/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.internal.dr;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.fp;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    private final String wK;
    private int wL;
    private String wM;
    private MediaMetadata wN;
    private long wO;
    private JSONObject wP;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.wK = contentId;
        this.wL = -1;
    }

    MediaInfo(JSONObject json) throws JSONException {
        this.wK = json.getString("contentId");
        String string = json.getString("streamType");
        this.wL = "NONE".equals(string) ? 0 : ("BUFFERED".equals(string) ? 1 : ("LIVE".equals(string) ? 2 : -1));
        this.wM = json.getString("contentType");
        if (json.has("metadata")) {
            JSONObject jSONObject = json.getJSONObject("metadata");
            int n2 = jSONObject.getInt("metadataType");
            this.wN = new MediaMetadata(n2);
            this.wN.b(jSONObject);
        }
        this.wO = dr.b(json.optDouble("duration", 0.0));
        this.wP = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.wK;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.wL = streamType;
    }

    public int getStreamType() {
        return this.wL;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.wM = contentType;
    }

    public String getContentType() {
        return this.wM;
    }

    void a(MediaMetadata mediaMetadata) {
        this.wN = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.wN;
    }

    void j(long l2) throws IllegalArgumentException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Stream duration cannot be negative");
        }
        this.wO = l2;
    }

    public long getStreamDuration() {
        return this.wO;
    }

    void a(JSONObject jSONObject) {
        this.wP = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.wP;
    }

    void cS() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.wK)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.wM)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.wL == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject cT() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            jSONObject.put("contentId", (Object)this.wK);
            switch (this.wL) {
                case 1: {
                    string = "BUFFERED";
                    break;
                }
                case 2: {
                    string = "LIVE";
                    break;
                }
                default: {
                    string = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string);
            if (this.wM != null) {
                jSONObject.put("contentType", (Object)this.wM);
            }
            if (this.wN != null) {
                jSONObject.put("metadata", (Object)this.wN.cT());
            }
            jSONObject.put("duration", dr.l(this.wO));
            if (this.wP != null) {
                jSONObject.put("customData", (Object)this.wP);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.wP == null != (mediaInfo.wP == null)) {
            return false;
        }
        if (this.wP != null && mediaInfo.wP != null && !fp.d(this.wP, mediaInfo.wP)) {
            return false;
        }
        return dr.a(this.wK, mediaInfo.wK) && this.wL == mediaInfo.wL && dr.a(this.wM, mediaInfo.wM) && dr.a(this.wN, mediaInfo.wN) && this.wO == mediaInfo.wO;
    }

    public int hashCode() {
        return ep.hashCode(this.wK, this.wL, this.wM, this.wN, this.wO, String.valueOf(this.wP));
    }

    public static class Builder {
        private final MediaInfo wQ;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.wQ = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.wQ.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.wQ.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.wQ.a(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.wQ.j(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.wQ.a(customData);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.wQ.cS();
            return this.wQ;
        }
    }
}

