/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.dq;
import com.google.android.gms.internal.dv;
import com.google.android.gms.internal.dw;
import com.google.android.gms.internal.dx;
import java.io.IOException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object mg = new Object();
    private final dv xg;
    private final a xh = new a();
    private OnMetadataUpdatedListener xi;
    private OnStatusUpdatedListener xj;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_CANCELED = 2;
    public static final int STATUS_TIMED_OUT = 3;
    public static final int STATUS_REPLACED = 4;

    public RemoteMediaPlayer() {
        this.xg = new dv(){

            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }
        };
        this.xg.a(this.xh);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dq dq2) {
                Object object = RemoteMediaPlayer.this.mg;
                synchronized (object) {
                    RemoteMediaPlayer.this.xh.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.xg.a(this.xy, mediaInfo, autoplay, playPosition, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.xh.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dq dq2) {
                Object object = RemoteMediaPlayer.this.mg;
                synchronized (object) {
                    RemoteMediaPlayer.this.xh.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.xg.a(this.xy, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.xh.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dq dq2) {
                Object object = RemoteMediaPlayer.this.mg;
                synchronized (object) {
                    RemoteMediaPlayer.this.xh.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.xg.b(this.xy, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.xh.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dq dq2) {
                Object object = RemoteMediaPlayer.this.mg;
                synchronized (object) {
                    RemoteMediaPlayer.this.xh.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.xg.c(this.xy, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.xh.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dq dq2) {
                Object object = RemoteMediaPlayer.this.mg;
                synchronized (object) {
                    RemoteMediaPlayer.this.xh.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.xg.a(this.xy, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.xh.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dq dq2) {
                Object object = RemoteMediaPlayer.this.mg;
                synchronized (object) {
                    RemoteMediaPlayer.this.xh.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.xg.a(this.xy, volume, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.a(this.j(new Status(1)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.a(this.j(new Status(1)));
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.xh.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dq dq2) {
                Object object = RemoteMediaPlayer.this.mg;
                synchronized (object) {
                    RemoteMediaPlayer.this.xh.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.xg.a(this.xy, muteState, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.a(this.j(new Status(1)));
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.xh.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dq dq2) {
                Object object = RemoteMediaPlayer.this.mg;
                synchronized (object) {
                    RemoteMediaPlayer.this.xh.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.xg.a(this.xy);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.xh.b(null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mg;
        synchronized (object) {
            return this.xg.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mg;
        synchronized (object) {
            return this.xg.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mg;
        synchronized (object) {
            return this.xg.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mg;
        synchronized (object) {
            return this.xg.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.xj = listener;
    }

    private void onStatusUpdated() {
        if (this.xj != null) {
            this.xj.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.xi = listener;
    }

    private void onMetadataUpdated() {
        if (this.xi != null) {
            this.xi.onMetadataUpdated();
        }
    }

    public String getNamespace() {
        return this.xg.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.xg.P(message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class b
    extends Cast.a<MediaChannelResult> {
        dx xy = new dx(){

            public void k(long l2) {
                b.this.a(b.this.j(new Status(4)));
            }

            public void a(long l2, int n2, JSONObject jSONObject) {
                b.this.a(new c(new Status(n2), jSONObject));
            }
        };

        b() {
        }

        public MediaChannelResult j(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.j(status);
        }
    }

    private static final class c
    implements MediaChannelResult {
        private final Status vl;
        private final JSONObject wP;

        c(Status status, JSONObject jSONObject) {
            this.vl = status;
            this.wP = jSONObject;
        }

        public Status getStatus() {
            return this.vl;
        }
    }

    public static interface MediaChannelResult
    extends Result {
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$a
    implements dw {
        private GoogleApiClient xu;
        private long xv = 0L;

        public void b(GoogleApiClient googleApiClient) {
            this.xu = googleApiClient;
        }

        public long cV() {
            return ++this.xv;
        }

        public void a(String string, String string2, long l2, String string3) throws IOException {
            if (this.xu == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.xu, string, string2).setResultCallback(new a(l2));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class a
        implements ResultCallback<Status> {
            private final long xw;

            a(long l2) {
                this.xw = l2;
            }

            public void i(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.xg.a(this.xw, status.getStatusCode());
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.i((Status)x0);
            }
        }
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

