/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.api.b;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.er;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface GoogleApiClient {
    public <A extends Api.a, T extends a.a<? extends Result, A>> T a(T var1);

    public <A extends Api.a, T extends a.a<? extends Result, A>> T b(T var1);

    public <C extends Api.a> C a(Api.b<C> var1);

    public void connect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public static final class Builder {
        private String vi;
        private final Set<String> zn = new HashSet<String>();
        private int zo;
        private View zp;
        private String zq;
        private final Context mContext;
        private final Map<Api, ApiOptions> zr = new HashMap<Api, ApiOptions>();
        private Looper zs;
        private final Set<ConnectionCallbacks> zt = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> zu = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.zs = context.getMainLooper();
            this.zq = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            er.b(connectedListener, (Object)"Must provide a connected listener");
            this.zt.add(connectedListener);
            er.b(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zu.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            er.b(handler, (Object)"Handler must not be null");
            this.zs = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.zt.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.zu.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.zp = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.zn.add(scope.dD());
            return this;
        }

        public Builder addApi(Api api) {
            return this.addApi(api, null);
        }

        public Builder addApi(Api api, ApiOptions options) {
            this.zr.put(api, options);
            List<Scope> list = api.dq();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.zn.add(list.get(i2).dD());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.vi = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.zo = gravityForPopups;
            return this;
        }

        public ee dx() {
            return new ee(this.vi, this.zn, this.zo, this.zp, this.zq);
        }

        public GoogleApiClient build() {
            return new b(this.mContext, this.zs, this.dx(), this.zr, this.zt, this.zu);
        }
    }

    public static interface ApiOptions {
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

