/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ep;

public final class Status
implements Result,
SafeParcelable {
    public static final Status zQ = new Status(0, null, null);
    public static final Status zR = new Status(14, null, null);
    public static final Status zS = new Status(15, null, null);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int wj;
    private final int yJ;
    private final String zT;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.wj = versionCode;
        this.yJ = statusCode;
        this.zT = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(1, statusCode, null, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent dE() {
        return this.mPendingIntent;
    }

    String dF() {
        return this.zT;
    }

    int getVersionCode() {
        return this.wj;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.yJ <= 0;
    }

    public boolean isInterrupted() {
        return this.yJ == 14;
    }

    public int getStatusCode() {
        return this.yJ;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return ep.hashCode(this.wj, this.yJ, this.zT, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.wj == status.wj && this.yJ == status.yJ && ep.equal(this.zT, status.zT) && ep.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String dn() {
        if (this.zT != null) {
            return this.zT;
        }
        return CommonStatusCodes.getStatusCodeString(this.yJ);
    }

    public String toString() {
        return ep.e(this).a("statusCode", this.dn()).a("resolution", this.mPendingIntent).toString();
    }

    @Deprecated
    public ConnectionResult dG() {
        return new ConnectionResult(this.yJ, this.mPendingIntent);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    public Status getStatus() {
        return this;
    }
}

