/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.b;
import com.google.android.gms.internal.er;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class a {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class b<R extends Result>
    extends Handler {
        public b() {
            this(Looper.getMainLooper());
        }

        public b(Looper looper) {
            super(looper);
        }

        public void a(ResultCallback<R> resultCallback, R r2) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r2)));
        }

        public void a(a<R, ?> a2, long l2) {
            this.sendMessageDelayed(this.obtainMessage(2, a2), l2);
        }

        public void dw() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.b((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    a a2 = (a)msg.obj;
                    a2.a(a2.d(Status.zS));
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void b(ResultCallback<R> resultCallback, R r2) {
            resultCallback.onResult(r2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class a<R extends Result, A extends Api.a>
    implements PendingResult<R>,
    c<R>,
    b.c<A> {
        private final Api.b<A> zc;
        private final Object zd = new Object();
        private b<R> ze;
        private final CountDownLatch zf = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> zg = new ArrayList();
        private ResultCallback<R> zh;
        private volatile R zi;
        private volatile boolean zj;
        private boolean zk;
        private boolean zl;
        private b.a zm;

        protected a() {
            this(null);
        }

        protected a(Api.b<A> b2) {
            this.zc = b2;
        }

        @Override
        public final Api.b<A> dp() {
            return this.zc;
        }

        @Override
        public final void b(A a2) throws DeadObjectException {
            this.ze = new b(a2.getLooper());
            try {
                this.a((R)a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public void a(b.a a2) {
            this.zm = a2;
        }

        @Override
        public int dr() {
            return 0;
        }

        protected abstract void a(A var1) throws RemoteException;

        protected abstract R d(Status var1);

        public final boolean isReady() {
            return this.zf.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R ds() {
            Object object = this.zd;
            synchronized (object) {
                er.a(!this.zj, "Result has already been consumed.");
                er.a(this.isReady(), "Result is not ready.");
                R r2 = this.zi;
                this.dt();
                return r2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final R await() {
            er.a(!this.zj, "Results has already been consumed");
            er.a(this.isReady() || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
            try {
                this.zf.await();
            }
            catch (InterruptedException interruptedException) {
                Object object = this.zd;
                synchronized (object) {
                    this.a(this.d(Status.zR));
                    this.zl = true;
                }
            }
            er.a(this.isReady(), "Result is not ready.");
            return this.ds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final R await(long time, TimeUnit units) {
            block8: {
                er.a(!this.zj, "Result has already been consumed.");
                er.a(this.isReady() || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
                try {
                    boolean bl2 = this.zf.await(time, units);
                    if (bl2) break block8;
                    Object object = this.zd;
                    synchronized (object) {
                        this.a(this.d(Status.zS));
                        this.zl = true;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object object = this.zd;
                    synchronized (object) {
                        this.a(this.d(Status.zR));
                        this.zl = true;
                    }
                }
            }
            er.a(this.isReady(), "Result is not ready.");
            return this.ds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            er.a(!this.zj, "Result has already been consumed.");
            Object object = this.zd;
            synchronized (object) {
                if (this.isReady()) {
                    this.ze.a(callback, this.ds());
                } else {
                    this.zh = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            er.a(!this.zj, "Result has already been consumed.");
            Object object = this.zd;
            synchronized (object) {
                if (this.isReady()) {
                    this.ze.a(callback, this.ds());
                } else {
                    this.zh = callback;
                    this.ze.a(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void a(R r2) {
            Object object = this.zd;
            synchronized (object) {
                if (this.zl) {
                    if (r2 instanceof Releasable) {
                        ((Releasable)r2).release();
                    }
                    return;
                }
                er.a(!this.isReady(), "Results have already been set");
                er.a(!this.zj, "Result has already been consumed");
                this.zi = r2;
                if (this.zk) {
                    this.dv();
                    return;
                }
                this.zf.countDown();
                Status status = this.zi.getStatus();
                if (this.zh != null) {
                    this.ze.dw();
                    this.ze.a(this.zh, this.ds());
                }
                for (PendingResult.a a2 : this.zg) {
                    a2.k(status);
                }
                this.zg.clear();
            }
        }

        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.a(this.d(status));
        }

        void dt() {
            this.zj = true;
            this.zi = null;
            if (this.zm != null) {
                this.zm.b(this);
            }
        }

        @Override
        public void du() {
            this.dv();
            this.zk = true;
        }

        private void dv() {
            if (this.zi != null && this instanceof Releasable) {
                try {
                    ((Releasable)((Object)this)).release();
                }
                catch (Exception exception) {
                    Log.w((String)"GoogleApi", (String)("Unable to release " + this), (Throwable)exception);
                }
            }
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((R)((Result)object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface c<R> {
        public void b(R var1);
    }
}

