/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import com.google.android.gms.drive.metadata.CollectionMetadataField;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.OrderedMetadataField;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.query.internal.ComparisonFilter;
import com.google.android.gms.drive.query.internal.FieldOnlyFilter;
import com.google.android.gms.drive.query.internal.InFilter;
import com.google.android.gms.drive.query.internal.LogicalFilter;
import com.google.android.gms.drive.query.internal.NotFilter;
import com.google.android.gms.drive.query.internal.Operator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    public static <T> Filter eq(MetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.Fa, field, value);
    }

    public static <T extends Comparable<T>> Filter lessThan(OrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.Fb, field, value);
    }

    public static <T extends Comparable<T>> Filter greaterThan(OrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.Fd, field, value);
    }

    public static <T extends Comparable<T>> Filter lessThanEquals(OrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.Fc, field, value);
    }

    public static <T extends Comparable<T>> Filter greaterThanEquals(OrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.Fe, field, value);
    }

    public static <T> Filter in(CollectionMetadataField<T> field, T value) {
        return new InFilter<T>(field, value);
    }

    public static Filter contains(MetadataField<String> field, String value) {
        return new ComparisonFilter<String>(Operator.Fi, field, value);
    }

    public static Filter and(Filter filter, Filter ... additionalFilters) {
        return new LogicalFilter(Operator.Ff, filter, additionalFilters);
    }

    public static Filter and(Iterable<Filter> filters) {
        return new LogicalFilter(Operator.Ff, filters);
    }

    public static Filter or(Filter filter, Filter ... additionalFilters) {
        return new LogicalFilter(Operator.Fg, filter, additionalFilters);
    }

    public static Filter or(Iterable<Filter> filters) {
        return new LogicalFilter(Operator.Fg, filters);
    }

    public static Filter not(Filter toNegate) {
        return new NotFilter(toNegate);
    }

    public static Filter sharedWithMe() {
        return new FieldOnlyFilter(SearchableField.EH);
    }
}

