/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.fx;
import com.google.android.gms.internal.gf;
import com.google.android.gms.internal.gg;
import com.google.android.gms.internal.gh;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.gj;
import com.google.android.gms.internal.gk;
import com.google.android.gms.internal.gl;
import com.google.android.gms.internal.gm;
import com.google.android.gms.internal.gn;
import com.google.android.gms.internal.go;
import com.google.android.gms.internal.gp;
import com.google.android.gms.internal.gw;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    static final Api.b<fx> va = new Api.b<fx>(){

        public fx e(Context context, Looper looper, ee ee2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            GamesOptions gamesOptions = new GamesOptions();
            if (apiOptions != null) {
                er.b(apiOptions instanceof GamesOptions, (Object)"Must provide valid GamesOptions!");
                gamesOptions = (GamesOptions)apiOptions;
            }
            return new fx(context, looper, ee2.dV(), ee2.dR(), connectionCallbacks, onConnectionFailedListener, ee2.dU(), ee2.dS(), ee2.dW(), gamesOptions.Gc, gamesOptions.Gd, gamesOptions.Ge, gamesOptions.Gf, gamesOptions.Gg);
        }

        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public /* synthetic */ Api.a b(Context context, Looper looper, ee ee2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.e(context, looper, ee2, apiOptions, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api API = new Api(va, SCOPE_GAMES);
    public static final Scope FY = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api FZ = new Api(va, FY);
    public static final GamesMetadata GamesMetadata = new gh();
    public static final Achievements Achievements = new gf();
    public static final Leaderboards Leaderboards = new gj();
    public static final Invitations Invitations = new gi();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new gp();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new gn();
    public static final Multiplayer Ga = new gk();
    public static final Players Players = new gm();
    public static final Notifications Notifications = new gl();
    public static final Requests Requests = new go();
    public static final gw Gb = new gg();

    private Games() {
    }

    public static fx c(GoogleApiClient googleApiClient) {
        er.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        er.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        fx fx2 = googleApiClient.a(va);
        er.a(fx2 != null, "GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return fx2;
    }

    public static void setGravityForPopups(GoogleApiClient apiClient, int gravity) {
        Games.c(apiClient).aT(gravity);
    }

    public static void setViewForPopups(GoogleApiClient apiClient, View gamesContentView) {
        er.f(gamesContentView);
        Games.c(apiClient).e(gamesContentView);
    }

    public static String getCurrentAccountName(GoogleApiClient apiClient) {
        return Games.c(apiClient).fn();
    }

    public static String getAppId(GoogleApiClient apiClient) {
        return Games.c(apiClient).fB();
    }

    public static Intent getSettingsIntent(GoogleApiClient apiClient) {
        return Games.c(apiClient).fz();
    }

    public static PendingResult<Status> signOut(GoogleApiClient apiClient) {
        return apiClient.b(new b(){

            protected void a(fx fx2) {
                fx2.b(this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient apiClient) {
        return Games.c(apiClient).fA();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class b
    extends a<Status> {
        private b() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class a<R extends Result>
    extends a.a<R, fx>
    implements PendingResult<R> {
        public a() {
            super(va);
        }
    }

    public static final class GamesOptions
    implements GoogleApiClient.ApiOptions {
        final boolean Gc;
        final boolean Gd;
        final int Ge;
        final boolean Gf;
        final int Gg;

        private GamesOptions() {
            this.Gc = false;
            this.Gd = true;
            this.Ge = 17;
            this.Gf = false;
            this.Gg = 4368;
        }

        private GamesOptions(Builder builder) {
            this.Gc = builder.Gc;
            this.Gd = builder.Gd;
            this.Ge = builder.Ge;
            this.Gf = builder.Gf;
            this.Gg = builder.Gg;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean Gc = false;
            boolean Gd = true;
            int Ge = 17;
            boolean Gf = false;
            int Gg = 4368;

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup) {
                this.Gd = showConnectingPopup;
                this.Ge = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
                this.Gd = showConnectingPopup;
                this.Ge = gravity;
                return this;
            }

            public Builder setSdkVariant(int variant) {
                this.Gg = variant;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

