/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.fm;

public final class d
implements LeaderboardScore {
    private final long IQ;
    private final String IR;
    private final String IS;
    private final long IT;
    private final long IU;
    private final String IV;
    private final Uri IW;
    private final Uri IX;
    private final PlayerEntity IY;
    private final String IZ;
    private final String Ja;
    private final String Jb;

    public d(LeaderboardScore leaderboardScore) {
        this.IQ = leaderboardScore.getRank();
        this.IR = er.f(leaderboardScore.getDisplayRank());
        this.IS = er.f(leaderboardScore.getDisplayScore());
        this.IT = leaderboardScore.getRawScore();
        this.IU = leaderboardScore.getTimestampMillis();
        this.IV = leaderboardScore.getScoreHolderDisplayName();
        this.IW = leaderboardScore.getScoreHolderIconImageUri();
        this.IX = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.IY = player == null ? null : (PlayerEntity)player.freeze();
        this.IZ = leaderboardScore.getScoreTag();
        this.Ja = leaderboardScore.getScoreHolderIconImageUrl();
        this.Jb = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    public long getRank() {
        return this.IQ;
    }

    public String getDisplayRank() {
        return this.IR;
    }

    public void getDisplayRank(CharArrayBuffer dataOut) {
        fm.b(this.IR, dataOut);
    }

    public String getDisplayScore() {
        return this.IS;
    }

    public void getDisplayScore(CharArrayBuffer dataOut) {
        fm.b(this.IS, dataOut);
    }

    public long getRawScore() {
        return this.IT;
    }

    public long getTimestampMillis() {
        return this.IU;
    }

    public String getScoreHolderDisplayName() {
        if (this.IY == null) {
            return this.IV;
        }
        return this.IY.getDisplayName();
    }

    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.IY == null) {
            fm.b(this.IV, dataOut);
            return;
        }
        this.IY.getDisplayName(dataOut);
    }

    public Uri getScoreHolderIconImageUri() {
        if (this.IY == null) {
            return this.IW;
        }
        return this.IY.getIconImageUri();
    }

    public String getScoreHolderIconImageUrl() {
        if (this.IY == null) {
            return this.Ja;
        }
        return this.IY.getIconImageUrl();
    }

    public Uri getScoreHolderHiResImageUri() {
        if (this.IY == null) {
            return this.IX;
        }
        return this.IY.getHiResImageUri();
    }

    public String getScoreHolderHiResImageUrl() {
        if (this.IY == null) {
            return this.Jb;
        }
        return this.IY.getHiResImageUrl();
    }

    public Player getScoreHolder() {
        return this.IY;
    }

    public String getScoreTag() {
        return this.IZ;
    }

    public LeaderboardScore fZ() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return d.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return ep.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return d.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return ep.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && ep.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && ep.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && ep.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && ep.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && ep.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && ep.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && ep.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && ep.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && ep.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return d.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return ep.e(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("IconImageUrl", leaderboardScore.getScoreHolderIconImageUrl()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("HiResImageUrl", leaderboardScore.getScoreHolderHiResImageUrl()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.fZ();
    }
}

