/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.c;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.fm;
import com.google.android.gms.internal.fy;

public final class ParticipantEntity
extends fy
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new a();
    private final int wj;
    private final String GZ;
    private final String FE;
    private final Uri FJ;
    private final Uri FK;
    private final int Jy;
    private final String Jz;
    private final boolean JA;
    private final PlayerEntity JB;
    private final int JC;
    private final ParticipantResult JD;
    private final String FU;
    private final String FV;

    public ParticipantEntity(Participant participant) {
        this.wj = 3;
        this.GZ = participant.getParticipantId();
        this.FE = participant.getDisplayName();
        this.FJ = participant.getIconImageUri();
        this.FK = participant.getHiResImageUri();
        this.Jy = participant.getStatus();
        this.Jz = participant.ge();
        this.JA = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.JB = player == null ? null : new PlayerEntity(player);
        this.JC = participant.getCapabilities();
        this.JD = participant.getResult();
        this.FU = participant.getIconImageUrl();
        this.FV = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.wj = versionCode;
        this.GZ = participantId;
        this.FE = displayName;
        this.FJ = iconImageUri;
        this.FK = hiResImageUri;
        this.Jy = status;
        this.Jz = clientAddress;
        this.JA = connectedToRoom;
        this.JB = player;
        this.JC = capabilities;
        this.JD = result;
        this.FU = iconImageUrl;
        this.FV = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.wj;
    }

    public int getStatus() {
        return this.Jy;
    }

    public String ge() {
        return this.Jz;
    }

    public boolean isConnectedToRoom() {
        return this.JA;
    }

    public String getDisplayName() {
        if (this.JB == null) {
            return this.FE;
        }
        return this.JB.getDisplayName();
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.JB == null) {
            fm.b(this.FE, dataOut);
            return;
        }
        this.JB.getDisplayName(dataOut);
    }

    public Uri getIconImageUri() {
        if (this.JB == null) {
            return this.FJ;
        }
        return this.JB.getIconImageUri();
    }

    public String getIconImageUrl() {
        if (this.JB == null) {
            return this.FU;
        }
        return this.JB.getIconImageUrl();
    }

    public Uri getHiResImageUri() {
        if (this.JB == null) {
            return this.FK;
        }
        return this.JB.getHiResImageUri();
    }

    public String getHiResImageUrl() {
        if (this.JB == null) {
            return this.FV;
        }
        return this.JB.getHiResImageUrl();
    }

    public String getParticipantId() {
        return this.GZ;
    }

    public Player getPlayer() {
        return this.JB;
    }

    public ParticipantResult getResult() {
        return this.JD;
    }

    public int getCapabilities() {
        return this.JC;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return ep.hashCode(participant.getPlayer(), participant.getStatus(), participant.ge(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return ep.equal(participant2.getPlayer(), participant.getPlayer()) && ep.equal(participant2.getStatus(), participant.getStatus()) && ep.equal(participant2.ge(), participant.ge()) && ep.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && ep.equal(participant2.getDisplayName(), participant.getDisplayName()) && ep.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && ep.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && ep.equal(participant2.getCapabilities(), participant.getCapabilities()) && ep.equal(participant2.getResult(), participant.getResult());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return ep.e(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.ge()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("IconImageUrl", participant.getIconImageUrl()).a("HiResImage", participant.getHiResImageUri()).a("HiResImageUrl", participant.getHiResImageUrl()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.dZ()) {
            c.a(this, dest, flags);
        } else {
            dest.writeString(this.GZ);
            dest.writeString(this.FE);
            dest.writeString(this.FJ == null ? null : this.FJ.toString());
            dest.writeString(this.FK == null ? null : this.FK.toString());
            dest.writeInt(this.Jy);
            dest.writeString(this.Jz);
            dest.writeInt(this.JA ? 1 : 0);
            dest.writeInt(this.JB == null ? 0 : 1);
            if (this.JB != null) {
                this.JB.writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends c {
        a() {
        }

        public ParticipantEntity ao(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.dY());
            if (bl2 || ParticipantEntity.ae(ParticipantEntity.class.getCanonicalName())) {
                return super.ao(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n2 = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            String string6 = null;
            String string7 = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n2, string5, bl3, playerEntity, n3, participantResult, string6, string7);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.ao(x0);
        }
    }
}

