/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.er;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener JK;
    private final RoomStatusUpdateListener JL;
    private final RealTimeMessageReceivedListener JM;
    private final String GP;
    private final int Jv;
    private final String[] JN;
    private final Bundle JO;
    private final boolean JP;

    private RoomConfig(Builder builder) {
        this.JK = builder.JK;
        this.JL = builder.JL;
        this.JM = builder.JM;
        this.GP = builder.JQ;
        this.Jv = builder.Jv;
        this.JO = builder.JO;
        this.JP = builder.JP;
        int n2 = builder.JR.size();
        this.JN = builder.JR.toArray(new String[n2]);
        if (this.JM == null) {
            er.a(this.JP, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.JK;
    }

    public String getInvitationId() {
        return this.GP;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.JL;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.JM;
    }

    public int getVariant() {
        return this.Jv;
    }

    public String[] getInvitedPlayerIds() {
        return this.JN;
    }

    public Bundle getAutoMatchCriteria() {
        return this.JO;
    }

    public boolean isSocketEnabled() {
        return this.JP;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        final RoomUpdateListener JK;
        RoomStatusUpdateListener JL;
        RealTimeMessageReceivedListener JM;
        String JQ = null;
        int Jv = -1;
        ArrayList<String> JR = new ArrayList();
        Bundle JO;
        boolean JP = false;

        private Builder(RoomUpdateListener updateListener) {
            this.JK = er.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            er.f(invitationId);
            this.JQ = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.JL = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.JM = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            er.f(playerIds);
            this.JR.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            er.f(playerIds);
            this.JR.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            er.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.Jv = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.JP = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.JO = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

