/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.internal.er;
import java.util.ArrayList;

public final class TurnBasedMatchConfig {
    private final int Jv;
    private final String[] JN;
    private final Bundle JO;
    private final int JZ;

    private TurnBasedMatchConfig(Builder builder) {
        this.Jv = builder.Jv;
        this.JZ = builder.JZ;
        this.JO = builder.JO;
        int n2 = builder.JR.size();
        this.JN = builder.JR.toArray(new String[n2]);
    }

    public int getVariant() {
        return this.Jv;
    }

    public int getMinPlayers() {
        return this.JZ;
    }

    public String[] getInvitedPlayerIds() {
        return this.JN;
    }

    public Bundle getAutoMatchCriteria() {
        return this.JO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        int Jv = -1;
        ArrayList<String> JR = new ArrayList();
        Bundle JO = null;
        int JZ = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            er.f(playerId);
            this.JR.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            er.f(playerIds);
            this.JR.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            er.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.Jv = variant;
            return this;
        }

        public Builder setMinPlayers(int minPlayers) {
            this.JZ = minPlayers;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.JO = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfig(this);
        }
    }
}

