/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import com.google.android.gms.internal.ep;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int wj;
    private final GameEntity Jq;
    private final PlayerEntity Km;
    private final byte[] Kf;
    private final String Hh;
    private final ArrayList<PlayerEntity> Kn;
    private final int AI;
    private final long Jr;
    private final long Ko;
    private final Bundle Kp;

    public GameRequestEntity(GameRequest request) {
        this.wj = 1;
        this.Jq = new GameEntity(request.getGame());
        this.Km = new PlayerEntity(request.getSender());
        this.Hh = request.getRequestId();
        this.AI = request.getType();
        this.Jr = request.getCreationTimestamp();
        this.Ko = request.getExpirationTimestamp();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.Kf = null;
        } else {
            this.Kf = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.Kf, 0, byArray.length);
        }
        ArrayList<Player> arrayList = request.fU();
        int n2 = arrayList.size();
        this.Kn = new ArrayList(n2);
        this.Kp = new Bundle();
        for (int i2 = 0; i2 < n2; ++i2) {
            Player player = (Player)arrayList.get(i2).freeze();
            String string = player.getPlayerId();
            this.Kn.add((PlayerEntity)player);
            this.Kp.putInt(string, request.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses) {
        this.wj = versionCode;
        this.Jq = game;
        this.Km = sender;
        this.Kf = data;
        this.Hh = requestId;
        this.Kn = recipients;
        this.AI = type;
        this.Jr = creationTimestamp;
        this.Ko = expirationTimestamp;
        this.Kp = recipientStatuses;
    }

    public int getVersionCode() {
        return this.wj;
    }

    @Override
    public String getRequestId() {
        return this.Hh;
    }

    @Override
    public Game getGame() {
        return this.Jq;
    }

    @Override
    public Player getSender() {
        return this.Km;
    }

    @Override
    public Player getRecipient() {
        if (this.Kn.isEmpty()) {
            return null;
        }
        return this.Kn.get(0);
    }

    @Override
    public boolean isConsumed() {
        return this.getRecipientStatus() == 1;
    }

    @Override
    public ArrayList<Player> fU() {
        return new ArrayList<Player>(this.Kn);
    }

    @Override
    public byte[] getData() {
        return this.Kf;
    }

    @Override
    public int getType() {
        return this.AI;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Jr;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.Ko;
    }

    @Override
    public int getRecipientStatus() {
        return this.Kp.getInt(this.Kn.get(0).getPlayerId(), 0);
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.Kp.getInt(playerId, 0);
    }

    public Bundle gf() {
        return this.Kp;
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    static int a(GameRequest gameRequest) {
        return ep.hashCode(gameRequest.getGame(), gameRequest.fU(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.b(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    static boolean a(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return ep.equal(gameRequest2.getGame(), gameRequest.getGame()) && ep.equal(gameRequest2.fU(), gameRequest.fU()) && ep.equal(gameRequest2.getRequestId(), gameRequest.getRequestId()) && ep.equal(gameRequest2.getSender(), gameRequest.getSender()) && Arrays.equals(GameRequestEntity.b(gameRequest2), GameRequestEntity.b(gameRequest)) && ep.equal(gameRequest2.getType(), gameRequest.getType()) && ep.equal(gameRequest2.getCreationTimestamp(), gameRequest.getCreationTimestamp()) && ep.equal(gameRequest2.getExpirationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    private static int[] b(GameRequest gameRequest) {
        ArrayList<Player> arrayList = gameRequest.fU();
        int n2 = arrayList.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = gameRequest.getRecipientStatus(arrayList.get(i2).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    static String c(GameRequest gameRequest) {
        return ep.e(gameRequest).a("Game", gameRequest.getGame()).a("Sender", gameRequest.getSender()).a("Recipients", gameRequest.fU()).a("Data", gameRequest.getData()).a("RequestId", gameRequest.getRequestId()).a("Type", gameRequest.getType()).a("CreationTimestamp", gameRequest.getCreationTimestamp()).a("ExpirationTimestamp", gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.a(this, dest, flags);
    }
}

