/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.text.TextUtils;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.am;
import com.google.android.gms.internal.cd;
import com.google.android.gms.internal.cf;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.cm;
import com.google.android.gms.internal.cs;
import com.google.android.gms.internal.cv;
import com.google.android.gms.internal.da;
import com.google.android.gms.internal.z;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class cj {
    private static final SimpleDateFormat ow = new SimpleDateFormat("yyyyMMdd");

    public static String a(cd cd2, cm cm2, Location location) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (cd2.ob != null) {
                hashMap.put("ad_pos", cd2.ob);
            }
            cj.a(hashMap, cd2.oc);
            hashMap.put("format", cd2.kQ.ln);
            if (cd2.kQ.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (cd2.kQ.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (cd2.kQ.lp != null) {
                charSequence = new StringBuilder();
                for (ab ab2 : cd2.kQ.lp) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(ab2.width == -1 ? (int)((float)ab2.widthPixels / cm2.pc) : ab2.width);
                    charSequence.append("x");
                    charSequence.append(ab2.height == -2 ? (int)((float)ab2.heightPixels / cm2.pc) : ab2.height);
                }
                hashMap.put("sz", charSequence);
            }
            hashMap.put("slotname", cd2.adUnitId);
            hashMap.put("pn", cd2.applicationInfo.packageName);
            if (cd2.od != null) {
                hashMap.put("vc", cd2.od.versionCode);
            }
            hashMap.put("ms", cd2.oe);
            hashMap.put("seq_num", cd2.of);
            hashMap.put("session_id", cd2.og);
            hashMap.put("js", cd2.kN.pU);
            cj.a(hashMap, cm2);
            if (cd2.oc.versionCode >= 2 && cd2.oc.ll != null) {
                cj.a(hashMap, cd2.oc.ll);
            }
            if (cd2.versionCode >= 2) {
                hashMap.put("quality_signals", cd2.oh);
            }
            if (da.n(2)) {
                charSequence = cv.m(hashMap).toString(2);
                da.v("Ad Request JSON: " + (String)charSequence);
            }
            return cv.m(hashMap).toString();
        }
        catch (JSONException jSONException) {
            da.w("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    private static void a(HashMap<String, Object> hashMap, z z2) {
        String string2 = cs.aR();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (z2.le != -1L) {
            hashMap.put("cust_age", ow.format(new Date(z2.le)));
        }
        if (z2.extras != null) {
            hashMap.put("extras", z2.extras);
        }
        if (z2.lf != -1) {
            hashMap.put("cust_gender", z2.lf);
        }
        if (z2.lg != null) {
            hashMap.put("kw", z2.lg);
        }
        if (z2.tagForChildDirectedTreatment != -1) {
            hashMap.put("tag_for_child_directed_treatment", z2.tagForChildDirectedTreatment);
        }
        if (z2.lh) {
            hashMap.put("adtest", "on");
        }
        if (z2.versionCode >= 2) {
            if (z2.li) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)z2.lj)) {
                hashMap.put("ppid", z2.lj);
            }
            if (z2.lk != null) {
                cj.a(hashMap, z2.lk);
            }
        }
        if (z2.versionCode >= 3 && z2.lm != null) {
            hashMap.put("url", z2.lm);
        }
    }

    private static void a(HashMap<String, Object> hashMap, cm cm2) {
        hashMap.put("am", cm2.oM);
        hashMap.put("cog", cj.j(cm2.oN));
        hashMap.put("coh", cj.j(cm2.oO));
        if (!TextUtils.isEmpty((CharSequence)cm2.oP)) {
            hashMap.put("carrier", cm2.oP);
        }
        hashMap.put("gl", cm2.oQ);
        if (cm2.oR) {
            hashMap.put("simulator", 1);
        }
        hashMap.put("ma", cj.j(cm2.oS));
        hashMap.put("sp", cj.j(cm2.oT));
        hashMap.put("hl", cm2.oU);
        if (!TextUtils.isEmpty((CharSequence)cm2.oV)) {
            hashMap.put("mv", cm2.oV);
        }
        hashMap.put("muv", cm2.oW);
        if (cm2.oX != -2) {
            hashMap.put("cnt", cm2.oX);
        }
        hashMap.put("gnt", cm2.oY);
        hashMap.put("pt", cm2.oZ);
        hashMap.put("rm", cm2.pa);
        hashMap.put("riv", cm2.pb);
        hashMap.put("u_sd", Float.valueOf(cm2.pc));
        hashMap.put("sh", cm2.pe);
        hashMap.put("sw", cm2.pd);
    }

    private static void a(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f2 = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l2 = location.getTime() * 1000L;
        Long l3 = (long)(location.getLatitude() * 1.0E7);
        Long l4 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f2);
        hashMap2.put("lat", l3);
        hashMap2.put("long", l4);
        hashMap2.put("time", l2);
        hashMap.put("uule", hashMap2);
    }

    private static void a(HashMap<String, Object> hashMap, am am2) {
        String string2;
        String string3;
        if (Color.alpha((int)am2.lI) != 0) {
            hashMap.put("acolor", cj.m(am2.lI));
        }
        if (Color.alpha((int)am2.backgroundColor) != 0) {
            hashMap.put("bgcolor", cj.m(am2.backgroundColor));
        }
        if (Color.alpha((int)am2.lJ) != 0 && Color.alpha((int)am2.lK) != 0) {
            hashMap.put("gradientto", cj.m(am2.lJ));
            hashMap.put("gradientfrom", cj.m(am2.lK));
        }
        if (Color.alpha((int)am2.lL) != 0) {
            hashMap.put("bcolor", cj.m(am2.lL));
        }
        hashMap.put("bthick", Integer.toString(am2.lM));
        switch (am2.lN) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (am2.lO) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (am2.lP != null) {
            hashMap.put("channel", am2.lP);
        }
        if (Color.alpha((int)am2.lQ) != 0) {
            hashMap.put("dcolor", cj.m(am2.lQ));
        }
        if (am2.lR != null) {
            hashMap.put("font", am2.lR);
        }
        if (Color.alpha((int)am2.lS) != 0) {
            hashMap.put("hcolor", cj.m(am2.lS));
        }
        hashMap.put("headersize", Integer.toString(am2.lT));
        if (am2.lU != null) {
            hashMap.put("q", am2.lU);
        }
    }

    private static Integer j(boolean bl2) {
        return bl2 ? 1 : 0;
    }

    private static String m(int n2) {
        return String.format(Locale.US, "#%06x", n2 & 0xFFFFFF);
    }

    public static cf a(Context context, cd cd2, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_html", null);
            long l2 = -1L;
            long l3 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string7 = jSONObject.optString("orientation", null);
            int n2 = -1;
            if ("portrait".equals(string7)) {
                n2 = cv.aU();
            } else if ("landscape".equals(string7)) {
                n2 = cv.aT();
            }
            cf cf2 = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    da.w("Could not parse the mediation config: Missing required ad_base_url field");
                    return new cf(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                cf2 = ci.a(context, cd2.kN.pU, string4);
                string3 = cf2.nw;
                string6 = cf2.oi;
                l2 = cf2.oo;
            } else {
                da.w("Could not parse the mediation config: Missing required ad_html or ad_url field.");
                return new cf(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = cf2 == null ? null : cf2.mt;
            if (jSONArray != null) {
                if (list3 == null) {
                    list3 = new LinkedList<String>();
                }
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    list3.add(jSONArray.getString(i2));
                }
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = cf2 == null ? null : cf2.mu;
            if (jSONArray2 != null) {
                if (list2 == null) {
                    list2 = new LinkedList<String>();
                }
                for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                    list2.add(jSONArray2.getString(i3));
                }
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = cf2 == null ? null : cf2.om;
            if (jSONArray3 != null) {
                if (list == null) {
                    list = new LinkedList<String>();
                }
                for (int i4 = 0; i4 < jSONArray3.length(); ++i4) {
                    list.add(jSONArray3.getString(i4));
                }
            }
            if (cf2 != null) {
                if (cf2.orientation != -1) {
                    n2 = cf2.orientation;
                }
                if (cf2.oj > 0L) {
                    l3 = cf2.oj;
                }
            }
            return new cf(string3, string6, list3, list2, l3, false, -1L, list, -1L, n2, string5, l2);
        }
        catch (JSONException jSONException) {
            da.w("Could not parse the mediation config: " + jSONException.getMessage());
            return new cf(0);
        }
    }
}

