/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.hj;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String Hh = null;
        private int KU = 0;
        private long KV = Long.MIN_VALUE;
        private short KW = (short)-1;
        private double KX;
        private double KY;
        private float KZ;
        private int La = 0;
        private int Lb = -1;

        public Builder setRequestId(String requestId) {
            this.Hh = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.KU = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.KV = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.KW = 1;
            this.KX = latitude;
            this.KY = longitude;
            this.KZ = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.La = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.Lb = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.Hh == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.KU == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.KU & 4) != 0 && this.Lb < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.KV == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.KW == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.La < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new hj(this.Hh, this.KU, 1, this.KX, this.KY, this.KZ, this.KV, this.La, this.Lb);
        }
    }
}

