/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Looper;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.hi;
import com.google.android.gms.internal.hj;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationClient
implements GooglePlayServicesClient {
    public static final String KEY_LOCATION_CHANGED = "com.google.android.location.LOCATION";
    public static final String KEY_MOCK_LOCATION = "mockLocation";
    private final hi KO;

    public LocationClient(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
        this.KO = new hi(context, connectionCallbacks, connectionFailedListener, "location");
    }

    public void addGeofences(List<Geofence> geofences, PendingIntent pendingIntent, OnAddGeofencesResultListener listener) {
        ArrayList<hj> arrayList = null;
        if (geofences != null) {
            arrayList = new ArrayList<hj>();
            for (Geofence geofence : geofences) {
                er.b(geofence instanceof hj, (Object)"Geofence must be created using Geofence.Builder.");
                arrayList.add((hj)geofence);
            }
        }
        this.KO.addGeofences(arrayList, pendingIntent, listener);
    }

    public void removeGeofences(PendingIntent pendingIntent, OnRemoveGeofencesResultListener listener) {
        this.KO.removeGeofences(pendingIntent, listener);
    }

    public void removeGeofences(List<String> geofenceRequestIds, OnRemoveGeofencesResultListener listener) {
        this.KO.removeGeofences(geofenceRequestIds, listener);
    }

    public static boolean hasError(Intent intent) {
        return intent.hasExtra("gms_error_code");
    }

    public static int getErrorCode(Intent intent) {
        return intent.getIntExtra("gms_error_code", -1);
    }

    public static int getGeofenceTransition(Intent intent) {
        int n2 = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n2 == -1) {
            return -1;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4) {
            return n2;
        }
        return -1;
    }

    public static List<Geofence> getTriggeringGeofences(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(hj.h(byArray));
        }
        return arrayList2;
    }

    public Location getLastLocation() {
        return this.KO.getLastLocation();
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener) {
        this.KO.requestLocationUpdates(request, listener);
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        this.KO.requestLocationUpdates(request, listener, looper);
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.KO.requestLocationUpdates(request, callbackIntent);
    }

    public void removeLocationUpdates(LocationListener listener) {
        this.KO.removeLocationUpdates(listener);
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.KO.removeLocationUpdates(callbackIntent);
    }

    public void setMockMode(boolean isMockMode) {
        this.KO.setMockMode(isMockMode);
    }

    public void setMockLocation(Location mockLocation) {
        this.KO.setMockLocation(mockLocation);
    }

    @Override
    public void connect() {
        this.KO.connect();
    }

    @Override
    public void disconnect() {
        this.KO.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.KO.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.KO.isConnecting();
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.KO.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.KO.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.KO.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.KO.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.KO.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.KO.unregisterConnectionFailedListener(listener);
    }

    public static interface OnRemoveGeofencesResultListener {
        public void onRemoveGeofencesByRequestIdsResult(int var1, String[] var2);

        public void onRemoveGeofencesByPendingIntentResult(int var1, PendingIntent var2);
    }

    public static interface OnAddGeofencesResultListener {
        public void onAddGeofencesResult(int var1, String[] var2);
    }
}

