/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public interface ICameraUpdateFactoryDelegate
extends IInterface {
    public b zoomIn() throws RemoteException;

    public b zoomOut() throws RemoteException;

    public b scrollBy(float var1, float var2) throws RemoteException;

    public b zoomTo(float var1) throws RemoteException;

    public b zoomBy(float var1) throws RemoteException;

    public b zoomByWithFocus(float var1, int var2, int var3) throws RemoteException;

    public b newCameraPosition(CameraPosition var1) throws RemoteException;

    public b newLatLng(LatLng var1) throws RemoteException;

    public b newLatLngZoom(LatLng var1, float var2) throws RemoteException;

    public b newLatLngBounds(LatLngBounds var1, int var2) throws RemoteException;

    public b newLatLngBoundsWithSize(LatLngBounds var1, int var2, int var3, int var4) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate$a
    extends Binder
    implements ICameraUpdateFactoryDelegate {
        public static ICameraUpdateFactoryDelegate S(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
            if (iInterface != null && iInterface instanceof ICameraUpdateFactoryDelegate) {
                return (ICameraUpdateFactoryDelegate)iInterface;
            }
            return new a(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    b b2 = this.zoomIn();
                    reply.writeNoException();
                    reply.writeStrongBinder(b2 != null ? b2.asBinder() : null);
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    b b3 = this.zoomOut();
                    reply.writeNoException();
                    reply.writeStrongBinder(b3 != null ? b3.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f2 = data.readFloat();
                    float f3 = data.readFloat();
                    b b4 = this.scrollBy(f2, f3);
                    reply.writeNoException();
                    reply.writeStrongBinder(b4 != null ? b4.asBinder() : null);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f4 = data.readFloat();
                    b b5 = this.zoomTo(f4);
                    reply.writeNoException();
                    reply.writeStrongBinder(b5 != null ? b5.asBinder() : null);
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f5 = data.readFloat();
                    b b6 = this.zoomBy(f5);
                    reply.writeNoException();
                    reply.writeStrongBinder(b6 != null ? b6.asBinder() : null);
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f6 = data.readFloat();
                    int n2 = data.readInt();
                    int n3 = data.readInt();
                    b b7 = this.zoomByWithFocus(f6, n2, n3);
                    reply.writeNoException();
                    reply.writeStrongBinder(b7 != null ? b7.asBinder() : null);
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    CameraPosition cameraPosition = 0 != data.readInt() ? CameraPosition.CREATOR.createFromParcel(data) : null;
                    b b8 = this.newCameraPosition(cameraPosition);
                    reply.writeNoException();
                    reply.writeStrongBinder(b8 != null ? b8.asBinder() : null);
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.createFromParcel(data) : null;
                    b b9 = this.newLatLng(latLng);
                    reply.writeNoException();
                    reply.writeStrongBinder(b9 != null ? b9.asBinder() : null);
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.createFromParcel(data) : null;
                    float f7 = data.readFloat();
                    b b10 = this.newLatLngZoom(latLng, f7);
                    reply.writeNoException();
                    reply.writeStrongBinder(b10 != null ? b10.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != data.readInt() ? LatLngBounds.CREATOR.createFromParcel(data) : null;
                    int n4 = data.readInt();
                    b b11 = this.newLatLngBounds(latLngBounds, n4);
                    reply.writeNoException();
                    reply.writeStrongBinder(b11 != null ? b11.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != data.readInt() ? LatLngBounds.CREATOR.createFromParcel(data) : null;
                    int n5 = data.readInt();
                    int n6 = data.readInt();
                    int n7 = data.readInt();
                    b b12 = this.newLatLngBoundsWithSize(latLngBounds, n5, n6, n7);
                    reply.writeNoException();
                    reply.writeStrongBinder(b12 != null ? b12.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class a
        implements ICameraUpdateFactoryDelegate {
            private IBinder ky;

            a(IBinder iBinder) {
                this.ky = iBinder;
            }

            public IBinder asBinder() {
                return this.ky;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b zoomIn() throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.ky.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b zoomOut() throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.ky.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b scrollBy(float xPixel, float yPixel) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(xPixel);
                    parcel.writeFloat(yPixel);
                    this.ky.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b zoomTo(float zoom) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(zoom);
                    this.ky.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b zoomBy(float amount) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(amount);
                    this.ky.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b zoomByWithFocus(float amount, int screenFocusX, int screenFocusY) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(amount);
                    parcel.writeInt(screenFocusX);
                    parcel.writeInt(screenFocusY);
                    this.ky.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b newCameraPosition(CameraPosition cameraPosition) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (cameraPosition != null) {
                        parcel.writeInt(1);
                        cameraPosition.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.ky.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b newLatLng(LatLng latLng) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.ky.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b newLatLngZoom(LatLng latLng, float zoom) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeFloat(zoom);
                    this.ky.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b newLatLngBounds(LatLngBounds bounds, int padding) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (bounds != null) {
                        parcel.writeInt(1);
                        bounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(padding);
                    this.ky.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b newLatLngBoundsWithSize(LatLngBounds bounds, int width, int height, int padding) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (bounds != null) {
                        parcel.writeInt(1);
                        bounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(width);
                    parcel.writeInt(height);
                    parcel.writeInt(padding);
                    this.ky.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.G(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }
        }
    }
}

