/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import com.google.android.gms.maps.model.Tile;
import com.google.android.gms.maps.model.TileProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public abstract class UrlTileProvider
implements TileProvider {
    private final int w;
    private final int v;

    public UrlTileProvider(int width, int height) {
        this.w = width;
        this.v = height;
    }

    public abstract URL getTileUrl(int var1, int var2, int var3);

    public final Tile getTile(int x2, int y2, int zoom) {
        Tile tile;
        URL uRL = this.getTileUrl(x2, y2, zoom);
        if (uRL == null) {
            return NO_TILE;
        }
        try {
            tile = new Tile(this.w, this.v, UrlTileProvider.a(uRL.openStream()));
        }
        catch (IOException iOException) {
            tile = null;
        }
        return tile;
    }

    private static byte[] a(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        UrlTileProvider.a(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long a(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }
}

