/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.internal.fl;
import com.google.android.gms.internal.fn;
import com.google.android.gms.tagmanager.ab;
import com.google.android.gms.tagmanager.ak;
import com.google.android.gms.tagmanager.ap;
import com.google.android.gms.tagmanager.at;
import com.google.android.gms.tagmanager.au;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.cy;
import com.google.android.gms.tagmanager.db;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class cb
implements at {
    private static final String ua = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL,'%s' INTEGER NOT NULL);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time");
    private final b VL;
    private volatile ab VM;
    private final au VN;
    private final Context mContext;
    private final String ud;
    private long uf;
    private fl Ty;
    private final int ug;

    cb(au au2, Context context) {
        this(au2, context, "gtm_urls.db", 2000);
    }

    cb(au au2, Context context, String string, int n2) {
        this.mContext = context.getApplicationContext();
        this.ud = string;
        this.VN = au2;
        this.Ty = fn.eI();
        this.VL = new b(this.mContext, this.ud);
        this.VM = new db((HttpClient)new DefaultHttpClient(), this.mContext, new a());
        this.uf = 0L;
        this.ug = n2;
    }

    @Override
    public void e(long l2, String string) {
        this.cp();
        this.co();
        this.f(l2, string);
    }

    private void co() {
        int n2 = this.cq() - this.ug + 1;
        if (n2 > 0) {
            List<String> list = this.s(n2);
            bh.v("Store full, deleting " + list.size() + " hits to make room.");
            this.a(list.toArray(new String[0]));
        }
    }

    private void f(long l2, String string) {
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_time", Long.valueOf(l2));
        contentValues.put("hit_url", string);
        contentValues.put("hit_first_send_time", Integer.valueOf(0));
        try {
            sQLiteDatabase.insert("gtm_hits", null, contentValues);
            this.VN.p(false);
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error storing hit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> s(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            bh.w("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error in peekHits fetching hitIds: " + sQLiteException.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ap> t(int n2) {
        ArrayList<ap> arrayList = new ArrayList<ap>();
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_time", "hit_first_send_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    ap ap2 = new ap(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    arrayList.add(ap2);
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error in peekHits fetching hitIds: " + sQLiteException.getMessage());
            ArrayList<ap> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int n3 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((ap)arrayList.get(n3)).F(cursor.getString(1));
                    } else {
                        bh.w(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((ap)arrayList.get(n3)).ci()));
                    }
                    ++n3;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error in peekHits fetching hit url: " + sQLiteException.getMessage());
            ArrayList<ap> arrayList3 = new ArrayList<ap>();
            boolean bl2 = false;
            for (ap ap3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)ap3.jf())) {
                    if (bl2) break;
                    bl2 = true;
                }
                arrayList3.add(ap3);
            }
            ArrayList<ap> arrayList4 = arrayList3;
            return arrayList4;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int cp() {
        long l2 = this.Ty.currentTimeMillis();
        if (l2 <= this.uf + 86400000L) {
            return 0;
        }
        this.uf = l2;
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l3 = this.Ty.currentTimeMillis() - 2592000000L;
        int n2 = sQLiteDatabase.delete("gtm_hits", "HIT_TIME < ?", new String[]{Long.toString(l3)});
        this.VN.p(this.cq() == 0);
        return n2;
    }

    void a(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("gtm_hits", string, stringArray);
            this.VN.p(this.cq() == 0);
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error deleting hits");
        }
    }

    private void u(long l2) {
        this.a(new String[]{String.valueOf(l2)});
    }

    private void c(long l2, long l3) {
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_first_send_time", Long.valueOf(l3));
        try {
            sQLiteDatabase.update("gtm_hits", contentValues, "hit_id=?", new String[]{String.valueOf(l2)});
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error setting HIT_FIRST_DISPATCH_TIME for hitId: " + l2);
            this.u(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int cq() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from gtm_hits", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error getting numStoredHits");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int js() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_first_send_time"}, "hit_first_send_time=0", null, null, null, null);
            n2 = cursor.getCount();
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error getting num untried hits");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return n2;
    }

    @Override
    public void bp() {
        bh.v("GTM Dispatch running...");
        if (!this.VM.bA()) {
            return;
        }
        List<ap> list = this.t(40);
        if (list.isEmpty()) {
            bh.v("...nothing to dispatch");
            this.VN.p(true);
            return;
        }
        this.VM.e(list);
        if (this.js() > 0) {
            cy.kh().bp();
        }
    }

    private SQLiteDatabase G(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.VL.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            bh.w(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class b
    extends SQLiteOpenHelper {
        private boolean ui;
        private long uj;

        b(Context context, String string) {
            super(context, string, null, 1);
            this.uj = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string, SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = null;
            try {
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
            catch (SQLiteException sQLiteException) {
                bh.w("Error querying for table " + string);
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.ui && this.uj + 3600000L > cb.this.Ty.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.ui = true;
            this.uj = cb.this.Ty.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                cb.this.mContext.getDatabasePath(cb.this.ud).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.ui = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);
                try {
                    cursor.moveToFirst();
                }
                finally {
                    cursor.close();
                }
            }
            if (!this.a("gtm_hits", db2)) {
                db2.execSQL(ua);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM gtm_hits WHERE 0", null);
            HashSet<String> hashSet = new HashSet<String>();
            try {
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            finally {
                cursor.close();
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_time") && hashSet.remove("hit_first_send_time"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            ak.B(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }

    class a
    implements db.a {
        a() {
        }

        public void a(ap ap2) {
            cb.this.u(ap2.ci());
        }

        public void b(ap ap2) {
            cb.this.u(ap2.ci());
            bh.v("Permanent failure dispatching hitId: " + ap2.ci());
        }

        public void c(ap ap2) {
            long l2 = ap2.je();
            if (l2 == 0L) {
                cb.this.c(ap2.ci(), cb.this.Ty.currentTimeMillis());
            } else if (l2 + 14400000L < cb.this.Ty.currentTimeMillis()) {
                cb.this.u(ap2.ci());
                bh.v("Giving up on failed hitId: " + ap2.ci());
            }
        }
    }
}

