/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context mContext;
    private final Object zzbmz = new Object();
    private Camera zzbmA;
    private int zzbmB = 0;
    private int zzDE;
    private Size zzbmC;
    private float zzbmD = 30.0f;
    private int zzbmE = 1024;
    private int zzbmF = 768;
    private boolean zzbmG = false;
    private SurfaceView zzbmH;
    private SurfaceTexture zzbmI;
    private boolean zzbmJ;
    private Thread zzbmK;
    private zzb zzbmL;
    private Map<byte[], ByteBuffer> zzbmM = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbmz;
        synchronized (object) {
            this.stop();
            this.zzbmL.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.zzbmz;
        synchronized (object) {
            if (this.zzbmA != null) {
                return this;
            }
            this.zzbmA = this.zzIb();
            if (Build.VERSION.SDK_INT >= 11) {
                this.zzbmI = new SurfaceTexture(100);
                this.zzbmA.setPreviewTexture(this.zzbmI);
                this.zzbmJ = true;
            } else {
                this.zzbmH = new SurfaceView(this.mContext);
                this.zzbmA.setPreviewDisplay(this.zzbmH.getHolder());
                this.zzbmJ = false;
            }
            this.zzbmA.startPreview();
            this.zzbmK = new Thread(this.zzbmL);
            this.zzbmL.setActive(true);
            this.zzbmK.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzbmz;
        synchronized (object) {
            if (this.zzbmA != null) {
                return this;
            }
            this.zzbmA = this.zzIb();
            this.zzbmA.setPreviewDisplay(surfaceHolder);
            this.zzbmA.startPreview();
            this.zzbmK = new Thread(this.zzbmL);
            this.zzbmL.setActive(true);
            this.zzbmK.start();
            this.zzbmJ = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzbmz;
        synchronized (object) {
            this.zzbmL.setActive(false);
            if (this.zzbmK != null) {
                try {
                    this.zzbmK.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzbmK = null;
            }
            if (this.zzbmA != null) {
                this.zzbmA.stopPreview();
                this.zzbmA.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.zzbmJ) {
                        this.zzbmA.setPreviewTexture(null);
                    } else {
                        this.zzbmA.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"CameraSource", (String)("Failed to clear camera preview: " + exception));
                }
                this.zzbmA.release();
                this.zzbmA = null;
            }
            this.zzbmM.clear();
        }
    }

    public Size getPreviewSize() {
        return this.zzbmC;
    }

    public int getCameraFacing() {
        return this.zzbmB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutter, PictureCallback jpeg) {
        Object object = this.zzbmz;
        synchronized (object) {
            if (this.zzbmA != null) {
                zzd zzd2 = new zzd();
                zzd2.zzbmV = shutter;
                zzc zzc2 = new zzc();
                zzc2.zzbmU = jpeg;
                this.zzbmA.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private Camera zzIb() {
        int n = CameraSource.zzkp(this.zzbmB);
        if (n == -1) {
            throw new RuntimeException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n);
        zze zze2 = CameraSource.zza(camera, this.zzbmE, this.zzbmF);
        if (zze2 == null) {
            throw new RuntimeException("Could not find suitable preview size.");
        }
        Size size = zze2.zzId();
        this.zzbmC = zze2.zzIc();
        int[] nArray = this.zza(camera, this.zzbmD);
        if (nArray == null) {
            throw new RuntimeException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPictureSize(size.getWidth(), size.getHeight());
        parameters.setPreviewSize(this.zzbmC.getWidth(), this.zzbmC.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        this.zza(camera, parameters, n);
        if (this.zzbmG) {
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza());
        camera.addCallbackBuffer(this.zza(this.zzbmC));
        camera.addCallbackBuffer(this.zza(this.zzbmC));
        camera.addCallbackBuffer(this.zza(this.zzbmC));
        camera.addCallbackBuffer(this.zza(this.zzbmC));
        return camera;
    }

    private static int zzkp(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != n) continue;
            return i;
        }
        return -1;
    }

    private static zze zza(Camera camera, int n, int n2) {
        List<zze> list = CameraSource.zza(camera);
        zze zze2 = null;
        int n3 = Integer.MAX_VALUE;
        for (zze zze3 : list) {
            Size size = zze3.zzIc();
            int n4 = Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2);
            if (n4 >= n3) continue;
            zze2 = zze3;
            n3 = n4;
        }
        return zze2;
    }

    private static List<zze> zza(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block0: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        return arrayList;
    }

    @SuppressLint(value={"InlinedApi"})
    private int[] zza(Camera camera, float f) {
        int n = (int)(f * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        List list = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] nArray2 : list) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    private void zza(Camera camera, Camera.Parameters parameters, int n) {
        int n2;
        int n3;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        int n4 = 0;
        int n5 = windowManager.getDefaultDisplay().getRotation();
        switch (n5) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)("Bad rotation value: " + n5));
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n3 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n3) % 360;
        } else {
            n2 = n3 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        this.zzDE = n3 / 90;
        camera.setDisplayOrientation(n2);
        parameters.setRotation(n3);
    }

    @SuppressLint(value={"InlinedApi"})
    private byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        long l = size.getHeight() * size.getWidth() * n;
        int n2 = (int)Math.ceil((double)l / 8.0) + 1;
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzbmM.put(byArray, byteBuffer);
        return byArray;
    }

    private class zzb
    implements Runnable {
        private Detector<?> zzbmN;
        private long zzRD = SystemClock.elapsedRealtime();
        private final Object zzpV = new Object();
        private boolean zzbmQ = true;
        private long zzbmR;
        private int zzbmS = 0;
        private ByteBuffer zzbmT;

        zzb(Detector<?> detector) {
            this.zzbmN = detector;
        }

        @SuppressLint(value={"Assert"})
        void release() {
            assert (CameraSource.this.zzbmK.getState() == Thread.State.TERMINATED);
            this.zzbmN.release();
            this.zzbmN = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean active) {
            Object object = this.zzpV;
            synchronized (object) {
                this.zzbmQ = active;
                this.zzpV.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void zza(byte[] byArray, Camera camera) {
            Object object = this.zzpV;
            synchronized (object) {
                if (this.zzbmT != null) {
                    camera.addCallbackBuffer(this.zzbmT.array());
                    this.zzbmT = null;
                }
                this.zzbmR = SystemClock.elapsedRealtime() - this.zzRD;
                ++this.zzbmS;
                this.zzbmT = (ByteBuffer)CameraSource.this.zzbmM.get(byArray);
                this.zzpV.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.zzpV;
                synchronized (object) {
                    if (this.zzbmQ && this.zzbmT == null) {
                        try {
                            this.zzpV.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.zzbmQ) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.zzbmT, CameraSource.this.zzbmC.getWidth(), CameraSource.this.zzbmC.getHeight(), 17).setId(this.zzbmS).setTimestampMillis(this.zzbmR).setRotation(CameraSource.this.zzDE).build();
                    byteBuffer = this.zzbmT;
                    this.zzbmT = null;
                }
                try {
                    this.zzbmN.receiveFrame(frame);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)throwable);
                    continue;
                }
                finally {
                    CameraSource.this.zzbmA.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    private class zza
    implements Camera.PreviewCallback {
        private zza() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            CameraSource.this.zzbmL.zza(data, camera);
        }
    }

    private static class zze {
        private Size zzbmW;
        private Size zzbmX;

        public zze(Camera.Size size, Camera.Size size2) {
            this.zzbmW = new Size(size.width, size.height);
            this.zzbmX = new Size(size2.width, size2.height);
        }

        public Size zzIc() {
            return this.zzbmW;
        }

        public Size zzId() {
            return this.zzbmX;
        }
    }

    private class zzc
    implements Camera.PictureCallback {
        private PictureCallback zzbmU;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPictureTaken(byte[] data, Camera camera) {
            if (this.zzbmU != null) {
                this.zzbmU.onPictureTaken(data);
            }
            Object object = CameraSource.this.zzbmz;
            synchronized (object) {
                if (CameraSource.this.zzbmA != null) {
                    CameraSource.this.zzbmA.startPreview();
                }
            }
        }
    }

    private class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback zzbmV;

        private zzd() {
        }

        public void onShutter() {
            if (this.zzbmV != null) {
                this.zzbmV.onShutter();
            }
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zzbmN;
        private CameraSource zzbmO = new CameraSource();

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zzbmN = detector;
            this.zzbmO.mContext = context;
        }

        public Builder setRequestedFps(float fps) {
            if (fps <= 0.0f) {
                throw new IllegalArgumentException("Invalid fps: " + fps);
            }
            this.zzbmO.zzbmD = fps;
            return this;
        }

        public Builder setRequestedPreviewSize(int width, int height) {
            int n = 1000000;
            if (width <= 0 || width > 1000000 || height <= 0 || height > 1000000) {
                throw new IllegalArgumentException("Invalid preview size: " + width + "x" + height);
            }
            this.zzbmO.zzbmE = width;
            this.zzbmO.zzbmF = height;
            return this;
        }

        public Builder setFacing(int facing) {
            if (facing != 0 && facing != 1) {
                throw new IllegalArgumentException("Invalid camera: " + facing);
            }
            this.zzbmO.zzbmB = facing;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean autoFocusEnabled) {
            this.zzbmO.zzbmG = autoFocusEnabled;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.zzbmO;
            cameraSource.getClass();
            this.zzbmO.zzbmL = cameraSource.new zzb(this.zzbmN);
            return this.zzbmO;
        }
    }
}

