/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zzbmN;
    private Tracker<T> zzbnd;
    private int zzbne = 3;
    private boolean zzbnf = false;
    private int zzbng;
    private int zzbnh = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.zzbmN = detector;
        this.zzbnd = tracker;
    }

    @Override
    public void release() {
        this.zzbnd.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzbnh == this.zzbne) {
                this.zzbnd.onDone();
                this.zzbnf = false;
            } else {
                this.zzbnd.onMissing(detections);
            }
            ++this.zzbnh;
            return;
        }
        this.zzbnh = 0;
        if (this.zzbnf) {
            Object object2 = sparseArray.get(this.zzbng);
            if (object2 != null) {
                this.zzbnd.onUpdate(detections, object2);
                return;
            }
            this.zzbnd.onDone();
            this.zzbnf = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)("Invalid focus selected: " + n));
            return;
        }
        this.zzbnf = true;
        this.zzbng = n;
        this.zzbmN.setFocus(this.zzbng);
        this.zzbnd.onNewItem(this.zzbng, object);
        this.zzbnd.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected void zzkq(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid max gap: " + n);
        }
        this.zzbne = n;
    }
}

