/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzbni = new Metadata();
    private ByteBuffer zzbnj = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzbni;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzIe();
        }
        return this.zzbnj;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzIe() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        return ByteBuffer.wrap(byArray);
    }

    public static class Metadata {
        private int zzoG;
        private int zzoH;
        private int mId;
        private long zzaJi;
        private int zzDE;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzoG = metadata.getWidth();
            this.zzoH = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzaJi = metadata.getTimestampMillis();
            this.zzDE = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzoG;
        }

        public int getHeight() {
            return this.zzoH;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzaJi;
        }

        public int getRotation() {
            return this.zzDE;
        }

        public void zzIf() {
            if (this.zzDE % 2 != 0) {
                int n = this.zzoG;
                this.zzoG = this.zzoH;
                this.zzoH = n;
            }
            this.zzDE = 0;
        }
    }

    public static class Builder {
        private Frame zzbnk = new Frame();

        public Builder setBitmap(Bitmap image) {
            int n = image.getWidth();
            int n2 = image.getHeight();
            this.zzbnk.mBitmap = image;
            Metadata metadata = this.zzbnk.getMetadata();
            metadata.zzoG = n;
            metadata.zzoH = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer data, int width, int height, int format) {
            if (data == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (data.capacity() < width * height) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (format) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image format: " + format);
                }
            }
            this.zzbnk.zzbnj = data;
            Metadata metadata = this.zzbnk.getMetadata();
            metadata.zzoG = width;
            metadata.zzoH = height;
            return this;
        }

        public Builder setId(int id) {
            this.zzbnk.getMetadata().mId = id;
            return this;
        }

        public Builder setTimestampMillis(long timestampMillis) {
            this.zzbnk.getMetadata().zzaJi = timestampMillis;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.zzbnk.getMetadata().zzDE = rotation;
            return this;
        }

        public Frame build() {
            if (this.zzbnk.zzbnj == null && this.zzbnk.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzbnk;
        }
    }
}

