/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.graphics.PointF;
import com.google.android.gms.vision.face.Landmark;
import java.util.Arrays;
import java.util.List;

public class Face {
    public static final float UNCOMPUTED_PROBABILITY = -1.0f;
    private int mId;
    private PointF zzbnz;
    private float zzaTm;
    private float zzaTn;
    private float zzbnA;
    private float zzbnB;
    private List<Landmark> zzbnC;
    private float zzbnD;
    private float zzbnE;
    private float zzbnF;

    public PointF getPosition() {
        return new PointF(this.zzbnz.x - this.zzaTm / 2.0f, this.zzbnz.y - this.zzaTn / 2.0f);
    }

    public float getWidth() {
        return this.zzaTm;
    }

    public float getHeight() {
        return this.zzaTn;
    }

    public float getEulerY() {
        return this.zzbnA;
    }

    public float getEulerZ() {
        return this.zzbnB;
    }

    public List<Landmark> getLandmarks() {
        return this.zzbnC;
    }

    public float getIsLeftEyeOpenProbability() {
        return this.zzbnD;
    }

    public float getIsRightEyeOpenProbability() {
        return this.zzbnE;
    }

    public float getIsSmilingProbability() {
        return this.zzbnF;
    }

    public int getId() {
        return this.mId;
    }

    public Face(int id, PointF position, float width, float height, float yawDegrees, float rollDegrees, Landmark[] landmarks, float isLeftEyeOpenScore, float isRightEyeOpenScore, float isSmilingScore) {
        this.mId = id;
        this.zzbnz = position;
        this.zzaTm = width;
        this.zzaTn = height;
        this.zzbnA = yawDegrees;
        this.zzbnB = rollDegrees;
        this.zzbnC = Arrays.asList(landmarks);
        this.zzbnD = isLeftEyeOpenScore >= 0.0f && isLeftEyeOpenScore <= 1.0f ? isLeftEyeOpenScore : -1.0f;
        this.zzbnE = isRightEyeOpenScore >= 0.0f && isRightEyeOpenScore <= 1.0f ? isRightEyeOpenScore : -1.0f;
        this.zzbnF = this.zzbnF >= 0.0f && this.zzbnF <= 1.0f ? isSmilingScore : -1.0f;
    }
}

