/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.JoinOptions;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.zzb;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzh;
import com.google.android.gms.cast.internal.zzk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final int ACTIVE_INPUT_STATE_UNKNOWN = -1;
    public static final int ACTIVE_INPUT_STATE_NO = 0;
    public static final int ACTIVE_INPUT_STATE_YES = 1;
    public static final int STANDBY_STATE_UNKNOWN = -1;
    public static final int STANDBY_STATE_NO = 0;
    public static final int STANDBY_STATE_YES = 1;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    private static final Api.zza<zze, CastOptions> zzUJ = new Api.zza<zze, CastOptions>(){

        public zze zza(Context context, Looper looper, zzf zzf2, CastOptions castOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            zzx.zzb((Object)castOptions, (Object)"Setting the API options is required.");
            return new zze(context, looper, zzf2, castOptions.zzZL, castOptions.zzZN, castOptions.zzZM, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api<CastOptions> API = new Api("Cast.API", zzUJ, zzk.zzUI);
    public static final CastApi CastApi = new CastApi.zza();

    private Cast() {
    }

    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        @Deprecated
        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, LaunchOptions var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public int getActiveInputState(GoogleApiClient var1) throws IllegalStateException;

        public int getStandbyState(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        public static final class zza
        implements CastApi {
            @Override
            public void requestStatus(GoogleApiClient client) throws IOException, IllegalStateException {
                try {
                    ((zze)client.zza(zzk.zzUI)).zzoj();
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public PendingResult<Status> sendMessage(GoogleApiClient client, final String namespace, final String message) {
                return client.zzb((zza.zza)new zzh(client){

                    protected void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza(namespace, message, (zza.zzb<Status>)this);
                        }
                        catch (IllegalArgumentException | IllegalStateException runtimeException) {
                            this.zzbj(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId) {
                return client.zzb((zza.zza)new com.google.android.gms.cast.Cast$zza(client){

                    protected void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza(applicationId, false, (zza.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbj(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId, final LaunchOptions options) {
                return client.zzb((zza.zza)new com.google.android.gms.cast.Cast$zza(client){

                    protected void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza(applicationId, options, (zza.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbj(2001);
                        }
                    }
                });
            }

            @Override
            @Deprecated
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, String applicationId, boolean relaunchIfRunning) {
                LaunchOptions launchOptions = new LaunchOptions.Builder().setRelaunchIfRunning(relaunchIfRunning).build();
                return this.launchApplication(client, applicationId, launchOptions);
            }

            public PendingResult<ApplicationConnectionResult> zza(GoogleApiClient googleApiClient, final String string, final String string2, final JoinOptions joinOptions) {
                return googleApiClient.zzb((zza.zza)new com.google.android.gms.cast.Cast$zza(googleApiClient){

                    protected void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza(string, string2, joinOptions, (zza.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbj(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, String applicationId, String sessionId) {
                return this.zza(client, applicationId, sessionId, null);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, String applicationId) {
                return this.zza(client, applicationId, null, null);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client) {
                return this.zza(client, null, null, null);
            }

            @Override
            public PendingResult<Status> leaveApplication(GoogleApiClient client) {
                return client.zzb((zza.zza)new zzh(client){

                    protected void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zzb((zza.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbj(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client) {
                return client.zzb((zza.zza)new zzh(client){

                    protected void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza("", (zza.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbj(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client, final String sessionId) {
                return client.zzb((zza.zza)new zzh(client){

                    protected void zza(zze zze2) throws RemoteException {
                        if (TextUtils.isEmpty((CharSequence)sessionId)) {
                            this.zze(2001, "IllegalArgument: sessionId cannot be null or empty");
                            return;
                        }
                        try {
                            zze2.zza(sessionId, (zza.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbj(2001);
                        }
                    }
                });
            }

            @Override
            public void setVolume(GoogleApiClient client, double volume) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    ((zze)client.zza(zzk.zzUI)).zzf(volume);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public double getVolume(GoogleApiClient client) throws IllegalStateException {
                return ((zze)client.zza(zzk.zzUI)).zzok();
            }

            @Override
            public void setMute(GoogleApiClient client, boolean mute) throws IOException, IllegalStateException {
                try {
                    ((zze)client.zza(zzk.zzUI)).zzX(mute);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public boolean isMute(GoogleApiClient client) throws IllegalStateException {
                return ((zze)client.zza(zzk.zzUI)).isMute();
            }

            @Override
            public int getActiveInputState(GoogleApiClient client) throws IllegalStateException {
                return ((zze)client.zza(zzk.zzUI)).zzol();
            }

            @Override
            public int getStandbyState(GoogleApiClient client) throws IllegalStateException {
                return ((zze)client.zza(zzk.zzUI)).zzom();
            }

            @Override
            public ApplicationMetadata getApplicationMetadata(GoogleApiClient client) throws IllegalStateException {
                return ((zze)client.zza(zzk.zzUI)).getApplicationMetadata();
            }

            @Override
            public String getApplicationStatus(GoogleApiClient client) throws IllegalStateException {
                return ((zze)client.zza(zzk.zzUI)).getApplicationStatus();
            }

            @Override
            public void setMessageReceivedCallbacks(GoogleApiClient client, String namespace, MessageReceivedCallback callbacks) throws IOException, IllegalStateException {
                try {
                    ((zze)client.zza(zzk.zzUI)).zza(namespace, callbacks);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public void removeMessageReceivedCallbacks(GoogleApiClient client, String namespace) throws IOException, IllegalArgumentException {
                try {
                    ((zze)client.zza(zzk.zzUI)).zzcg(namespace);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    private static abstract class zza
    extends zzb<ApplicationConnectionResult> {
        public zza(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public ApplicationConnectionResult zzo(final Status status) {
            return new ApplicationConnectionResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public boolean getWasLaunched() {
                    return false;
                }

                @Override
                public String getSessionId() {
                    return null;
                }

                @Override
                public String getApplicationStatus() {
                    return null;
                }

                @Override
                public ApplicationMetadata getApplicationMetadata() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzo(status);
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zzZL;
        final Listener zzZM;
        private final int zzZN;

        private CastOptions(Builder builder) {
            this.zzZL = builder.zzZO;
            this.zzZM = builder.zzZP;
            this.zzZN = builder.zzZQ;
        }

        @Deprecated
        public static Builder builder(CastDevice castDevice, Listener castListener) {
            return new Builder(castDevice, castListener);
        }

        public static final class Builder {
            CastDevice zzZO;
            Listener zzZP;
            private int zzZQ;

            public Builder(CastDevice castDevice, Listener castListener) {
                zzx.zzb((Object)castDevice, (Object)"CastDevice parameter cannot be null");
                zzx.zzb((Object)castListener, (Object)"CastListener parameter cannot be null");
                this.zzZO = castDevice;
                this.zzZP = castListener;
                this.zzZQ = 0;
            }

            public Builder setVerboseLoggingEnabled(boolean enabled) {
                this.zzZQ = enabled ? (this.zzZQ |= 1) : (this.zzZQ &= 0xFFFFFFFE);
                return this;
            }

            public CastOptions build() {
                return new CastOptions(this);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
        }

        public void onApplicationDisconnected(int statusCode) {
        }

        public void onActiveInputStateChanged(int activeInputState) {
        }

        public void onStandbyStateChanged(int standbyState) {
        }

        public void onVolumeChanged() {
        }
    }
}

