/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzb();
    private final int mVersionCode;
    private String zzZT;
    String zzZU;
    private Inet4Address zzZV;
    private String zzZW;
    private String zzZX;
    private String zzZY;
    private int zzZZ;
    private List<WebImage> zzaaa;
    private int zzaab;
    private int zzBc;
    private String zzaac;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities, int status, String serviceInstanceName) {
        this.mVersionCode = versionCode;
        this.zzZT = CastDevice.zzbZ(deviceId);
        this.zzZU = CastDevice.zzbZ(hostAddress);
        if (!TextUtils.isEmpty((CharSequence)this.zzZU)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzZU);
                if (inetAddress instanceof Inet4Address) {
                    this.zzZV = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                Log.i((String)"CastDevice", (String)("Unable to convert host address (" + this.zzZU + ") to ipaddress: " + unknownHostException.getMessage()));
            }
        }
        this.zzZW = CastDevice.zzbZ(friendlyName);
        this.zzZX = CastDevice.zzbZ(modelName);
        this.zzZY = CastDevice.zzbZ(deviceVersion);
        this.zzZZ = servicePort;
        this.zzaaa = icons != null ? icons : new ArrayList();
        this.zzaab = capabilities;
        this.zzBc = status;
        this.zzaac = CastDevice.zzbZ(serviceInstanceName);
    }

    private CastDevice() {
        this(4, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1, null);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getDeviceId() {
        if (this.zzZT.startsWith("__cast_nearby__")) {
            return this.zzZT.substring("__cast_nearby__".length() + 1);
        }
        return this.zzZT;
    }

    public String zzny() {
        return this.zzZT;
    }

    public Inet4Address getIpAddress() {
        return this.zzZV;
    }

    public String getFriendlyName() {
        return this.zzZW;
    }

    public String getModelName() {
        return this.zzZX;
    }

    public String getDeviceVersion() {
        return this.zzZY;
    }

    public String zznz() {
        return this.zzaac;
    }

    public int getServicePort() {
        return this.zzZZ;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzaaa);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.zzaaa.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.zzaaa.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzaaa) {
            int n = webImage3.getWidth();
            int n2 = webImage3.getHeight();
            if (n >= preferredWidth && n2 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n || webImage.getHeight() <= n2)) continue;
                webImage = webImage3;
                continue;
            }
            if (n >= preferredWidth || n2 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n || webImage2.getHeight() >= n2)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzaaa.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzaaa.isEmpty();
    }

    public int getCapabilities() {
        return this.zzaab;
    }

    public boolean hasCapability(int capability) {
        return (this.zzaab & capability) == capability;
    }

    public boolean hasCapabilities(int[] capabilities) {
        if (capabilities == null) {
            return false;
        }
        for (int n : capabilities) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzBc;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzZW, this.zzZT);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.zzZT == null) {
            return castDevice.zzZT == null;
        }
        return zzf.zza(this.zzZT, castDevice.zzZT) && zzf.zza(this.zzZV, castDevice.zzZV) && zzf.zza(this.zzZX, castDevice.zzZX) && zzf.zza(this.zzZW, castDevice.zzZW) && zzf.zza(this.zzZY, castDevice.zzZY) && this.zzZZ == castDevice.zzZZ && zzf.zza(this.zzaaa, castDevice.zzaaa) && this.zzaab == castDevice.zzaab && this.zzBc == castDevice.zzBc && zzf.zza(this.zzaac, castDevice.zzaac);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.zzZT == null) {
            return castDevice.zzZT == null;
        }
        return zzf.zza(this.zzZT, castDevice.zzZT);
    }

    public int hashCode() {
        return this.zzZT == null ? 0 : this.zzZT.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzZT.startsWith("__cast_nearby__");
    }

    private static String zzbZ(String string2) {
        return string2 == null ? "" : string2;
    }
}

