/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzl zzaaf = new zzl("CastRemoteDisplayLocalService");
    private static final int zzaag = R.id.cast_notification_id;
    private static final Object zzaah = new Object();
    private static AtomicBoolean zzaai = new AtomicBoolean(false);
    private GoogleApiClient zzaaj;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzaak;
    private String zzZC;
    private Callbacks zzaal;
    private zzb zzaam;
    private NotificationSettings zzaan;
    private Notification mNotification;
    private boolean zzaao;
    private PendingIntent zzaap;
    private CastDevice zzaaq;
    private Display zzaar;
    private Context zzaas;
    private ServiceConnection zzaat;
    private Handler mHandler;
    private MediaRouter zzaau;
    private boolean zzaav = false;
    private final MediaRouter.Callback zzaaw = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo info) {
            CastRemoteDisplayLocalService.this.zzbe("onRouteUnselected");
            if (CastRemoteDisplayLocalService.this.zzaaq == null) {
                CastRemoteDisplayLocalService.this.zzbe("onRouteUnselected, no device was selected");
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(info.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.zzaaq.getDeviceId())) {
                CastRemoteDisplayLocalService.this.zzbe("onRouteUnselected, device does not match");
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService zzaax;
    private final IBinder zzaay = new zza();

    public IBinder onBind(Intent intent) {
        this.zzbe("onBind");
        return this.zzaay;
    }

    public void onCreate() {
        this.zzbe("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CastRemoteDisplayLocalService.this.zzbe("onCreate after delay. The local service been started: " + CastRemoteDisplayLocalService.this.zzaav);
                if (!CastRemoteDisplayLocalService.this.zzaav) {
                    CastRemoteDisplayLocalService.this.zzbh("The local service has not been been started, stopping it");
                    CastRemoteDisplayLocalService.this.stopSelf();
                }
            }
        }, 100L);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.zzbe("onStartCommand");
        this.zzaav = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzaaf.zzY(true);
    }

    protected Display getDisplay() {
        return this.zzaar;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzaah;
        synchronized (object) {
            return zzaax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startService(final Context activityContext, Class<? extends CastRemoteDisplayLocalService> serviceClass, final String applicationId, final CastDevice device, final NotificationSettings notificationSettings, final Callbacks callbacks) {
        zzaaf.zzb("Starting Service", new Object[0]);
        Object object = zzaah;
        synchronized (object) {
            if (zzaax != null) {
                zzaaf.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzS(true);
            }
        }
        CastRemoteDisplayLocalService.zzb(activityContext, serviceClass);
        zzx.zzb((Object)activityContext, (Object)"activityContext is required.");
        zzx.zzb(serviceClass, (Object)"serviceClass is required.");
        zzx.zzb((Object)applicationId, (Object)"applicationId is required.");
        zzx.zzb((Object)device, (Object)"device is required.");
        zzx.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzx.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzaaF == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzaai.getAndSet(true)) {
            zzaaf.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(activityContext, serviceClass);
        activityContext.startService((Intent)object);
        activityContext.bindService((Intent)object, new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder binder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)binder).zznM();
                if (castRemoteDisplayLocalService == null || !castRemoteDisplayLocalService.zza(applicationId, device, notificationSettings, activityContext, this, callbacks)) {
                    zzaaf.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    zzaai.set(false);
                    try {
                        activityContext.unbindService((ServiceConnection)this);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzaaf.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                }
            }

            public void onServiceDisconnected(ComponentName arg0) {
                zzaaf.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                zzaai.set(false);
                try {
                    activityContext.unbindService((ServiceConnection)this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    zzaaf.zzb("No need to unbind service, already unbound", new Object[0]);
                }
            }
        }, 64);
    }

    private void zzQ(final boolean bl) {
        if (this.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CastRemoteDisplayLocalService.this.zzR(bl);
                    }
                });
            } else {
                this.zzR(bl);
            }
        }
    }

    private void zzR(boolean bl) {
        this.zzbe("Stopping Service");
        zzx.zzcD((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzaau != null) {
            this.zzbe("Setting default route");
            this.zzaau.selectRoute(this.zzaau.getDefaultRoute());
        }
        if (this.zzaam != null) {
            this.zzbe("Unregistering notification receiver");
            this.unregisterReceiver(this.zzaam);
        }
        this.zznF();
        this.zznG();
        this.zznB();
        if (this.zzaaj != null) {
            this.zzaaj.disconnect();
            this.zzaaj = null;
        }
        if (this.zzaas != null && this.zzaat != null) {
            try {
                this.zzaas.unbindService(this.zzaat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzbe("No need to unbind service, already unbound");
            }
            this.zzaat = null;
            this.zzaas = null;
        }
        this.zzZC = null;
        this.zzaaj = null;
        this.mNotification = null;
        this.zzaar = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzS(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzaaf.zzb("Stopping Service", new Object[0]);
        zzaai.set(false);
        Object object = zzaah;
        synchronized (object) {
            if (zzaax == null) {
                zzaaf.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzaax;
            zzaax = null;
        }
        castRemoteDisplayLocalService.zzQ(bl);
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzS(false);
    }

    public void updateNotificationSettings(final NotificationSettings notificationSettings) {
        zzx.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzx.zzb((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CastRemoteDisplayLocalService.this.zza(notificationSettings);
            }
        });
    }

    private void zza(NotificationSettings notificationSettings) {
        zzx.zzcD((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzaan == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzaao) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzaaF != null) {
                this.zzaan.zzaaF = notificationSettings.zzaaF;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzaaG)) {
                this.zzaan.zzaaG = notificationSettings.zzaaG;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzaaH)) {
                this.zzaan.zzaaH = notificationSettings.zzaaH;
            }
            this.mNotification = this.zzT(true);
        } else {
            zzx.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzaan.mNotification = this.mNotification;
        }
        this.startForeground(zzaag, this.mNotification);
    }

    private static void zzb(Context context, Class clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzaar = display;
        if (this.zzaao) {
            this.mNotification = this.zzT(true);
            this.startForeground(zzaag, this.mNotification);
        }
        if (this.zzaal != null) {
            this.zzaal.onRemoteDisplaySessionStarted(this);
            this.zzaal = null;
        }
        this.onCreatePresentation(this.zzaar);
    }

    private void zznB() {
        if (this.zzaau != null) {
            zzx.zzcD((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzbe("removeMediaRouterCallback");
            this.zzaau.removeCallback(this.zzaaw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(String string2, CastDevice castDevice, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzbe("startRemoteDisplaySession");
        zzx.zzcD((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzaah;
        synchronized (object) {
            if (zzaax != null) {
                zzaaf.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzaax = this;
        }
        this.zzaal = callbacks;
        this.zzZC = string2;
        this.zzaaq = castDevice;
        this.zzaas = context;
        this.zzaat = serviceConnection;
        this.zzaau = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzZC)).build();
        this.zzbe("addMediaRouterCallback");
        this.zzaau.addCallback((MediaRouteSelector)object, this.zzaaw, 4);
        this.zzaak = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                zzaaf.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                CastRemoteDisplayLocalService.zzS(false);
            }
        };
        this.mNotification = notificationSettings.mNotification;
        this.zzaam = new zzb();
        this.registerReceiver(this.zzaam, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzaan = new NotificationSettings(notificationSettings);
        if (this.zzaan.mNotification == null) {
            this.zzaao = true;
            this.mNotification = this.zzT(false);
        } else {
            this.zzaao = false;
            this.mNotification = this.zzaan.mNotification;
        }
        this.startForeground(zzaag, this.mNotification);
        this.zzaaj = this.zza(castDevice);
        this.zzaaj.connect();
        if (this.zzaal != null) {
            this.zzaal.onServiceCreated(this);
        }
        return true;
    }

    private void zznC() {
        this.zzbe("startRemoteDisplay");
        if (this.zzaaj == null || !this.zzaaj.isConnected()) {
            zzaaf.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzaaj, this.zzZC).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzaaf.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zznE();
                    return;
                }
                zzaaf.zzb("startRemoteDisplay successful", new Object[0]);
                Object object = zzaah;
                synchronized (object) {
                    if (zzaax == null) {
                        zzaaf.zzb("Remote Display started but session already cancelled", new Object[0]);
                        CastRemoteDisplayLocalService.this.zznE();
                        return;
                    }
                }
                object = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (object != null) {
                    CastRemoteDisplayLocalService.this.zza((Display)object);
                } else {
                    zzaaf.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                zzaai.set(false);
                if (CastRemoteDisplayLocalService.this.zzaas != null && CastRemoteDisplayLocalService.this.zzaat != null) {
                    try {
                        CastRemoteDisplayLocalService.this.zzaas.unbindService(CastRemoteDisplayLocalService.this.zzaat);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzaaf.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                    CastRemoteDisplayLocalService.this.zzaat = null;
                    CastRemoteDisplayLocalService.this.zzaas = null;
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zznD() {
        this.zzbe("stopRemoteDisplay");
        if (this.zzaaj == null || !this.zzaaj.isConnected()) {
            zzaaf.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.zzaaj).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    CastRemoteDisplayLocalService.this.zzbe("Unable to stop the remote display, result unsuccessful");
                } else {
                    CastRemoteDisplayLocalService.this.zzbe("remote display stopped");
                }
                CastRemoteDisplayLocalService.this.zzaar = null;
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zznE() {
        if (this.zzaal != null) {
            this.zzaal.onRemoteDisplaySessionError(new Status(2200));
            this.zzaal = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zznF() {
        this.zzbe("stopRemoteDisplaySession");
        this.zznD();
        this.onDismissPresentation();
    }

    private void zznG() {
        this.zzbe("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.zzaak);
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                CastRemoteDisplayLocalService.this.zzbe("onConnected");
                CastRemoteDisplayLocalService.this.zznC();
            }

            public void onConnectionSuspended(int cause) {
                zzaaf.zzf(String.format("[Instance: %s] ConnectionSuspended %d", this, cause), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                CastRemoteDisplayLocalService.this.zzbh("Connection failed: " + connectionResult);
                CastRemoteDisplayLocalService.this.zznE();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
    }

    private PendingIntent zznH() {
        if (this.zzaap == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            this.zzaap = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.zzaap;
    }

    private Notification zzT(boolean bl) {
        int n;
        int n2;
        this.zzbe("createDefaultNotification");
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.zzaan.zzaaG;
        String string3 = this.zzaan.zzaaH;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzaaq.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzaan.zzaaF).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zznH()).build();
        return notification;
    }

    private void zzbe(String string2) {
        zzaaf.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private void zzbh(String string2) {
        zzaaf.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zznM() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzaaf.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzaaF;
        private String zzaaG;
        private String zzaaH;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings newSettings) {
            this.mNotification = newSettings.mNotification;
            this.zzaaF = newSettings.zzaaF;
            this.zzaaG = newSettings.zzaaG;
            this.zzaaH = newSettings.zzaaH;
        }

        public static final class Builder {
            private NotificationSettings zzaaI = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.zzaaI.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent notificationPendingIntent) {
                this.zzaaI.zzaaF = notificationPendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String notificationTitle) {
                this.zzaaI.zzaaG = notificationTitle;
                return this;
            }

            public Builder setNotificationText(String notificationText) {
                this.zzaaI.zzaaH = notificationText;
                return this;
            }

            public NotificationSettings build() {
                if (this.zzaaI.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzaaI.zzaaG)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzaaI.zzaaH)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzaaI.zzaaF != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzaaI.zzaaG) && TextUtils.isEmpty((CharSequence)this.zzaaI.zzaaH) && this.zzaaI.zzaaF == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzaaI;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

