/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zznb;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String zzaaN;
    private int zzaaO;
    private String zzaaP;
    private MediaMetadata zzaaQ;
    private long zzaaR;
    private List<MediaTrack> zzaaS;
    private TextTrackStyle zzaaT;
    private JSONObject zzaaU;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.zzaaN = contentId;
        this.zzaaO = -1;
        this.zzaaR = -1L;
    }

    MediaInfo(JSONObject json) throws JSONException {
        double d;
        int n;
        JSONObject jSONObject;
        this.zzaaN = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.zzaaO = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzaaP = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n = jSONObject.getInt("metadataType");
            this.zzaaQ = new MediaMetadata(n);
            this.zzaaQ.zzg(jSONObject);
        }
        this.zzaaR = -1L;
        if (json.has("duration") && !json.isNull("duration") && !Double.isNaN(d = json.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzaaR = zzf.zzg(d);
        }
        if (json.has("tracks")) {
            this.zzaaS = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n = 0; n < jSONObject.length(); ++n) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.zzaaS.add(mediaTrack);
            }
        } else {
            this.zzaaS = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzg(jSONObject);
            this.zzaaT = textTrackStyle;
        } else {
            this.zzaaT = null;
        }
        this.zzaaU = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzaaN;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzaaO = streamType;
    }

    public int getStreamType() {
        return this.zzaaO;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzaaP = contentType;
    }

    public String getContentType() {
        return this.zzaaP;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzaaQ = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzaaQ;
    }

    void zzx(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzaaR = l;
    }

    public long getStreamDuration() {
        return this.zzaaR;
    }

    void zzu(List<MediaTrack> list) {
        this.zzaaS = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzaaS;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzaaT = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzaaT;
    }

    void setCustomData(JSONObject customData) {
        this.zzaaU = customData;
    }

    public JSONObject getCustomData() {
        return this.zzaaU;
    }

    void zznN() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzaaN)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzaaP)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzaaO == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzaaN);
            switch (this.zzaaO) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzaaP != null) {
                jSONObject.put("contentType", (Object)this.zzaaP);
            }
            if (this.zzaaQ != null) {
                jSONObject.put("metadata", (Object)this.zzaaQ.toJson());
            }
            if (this.zzaaR <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzf.zzA(this.zzaaR));
            }
            if (this.zzaaS != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzaaS) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzaaT != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzaaT.toJson());
            }
            if (this.zzaaU != null) {
                jSONObject.put("customData", (Object)this.zzaaU);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.zzaaU == null != (mediaInfo.zzaaU == null)) {
            return false;
        }
        if (this.zzaaU != null && mediaInfo.zzaaU != null && !zznb.zze((Object)this.zzaaU, (Object)mediaInfo.zzaaU)) {
            return false;
        }
        return zzf.zza(this.zzaaN, mediaInfo.zzaaN) && this.zzaaO == mediaInfo.zzaaO && zzf.zza(this.zzaaP, mediaInfo.zzaaP) && zzf.zza(this.zzaaQ, mediaInfo.zzaaQ) && this.zzaaR == mediaInfo.zzaaR;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaaN, this.zzaaO, this.zzaaP, this.zzaaQ, this.zzaaR, String.valueOf(this.zzaaU)});
    }

    public static class Builder {
        private final MediaInfo zzaaV;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzaaV = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.zzaaV.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.zzaaV.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.zzaaV.zza(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.zzaaV.zzx(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzaaV.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.zzaaV.zzu(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzaaV.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzaaV.zznN();
            return this.zzaaV;
        }
    }
}

