/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zznb;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long zzUZ;
    private int zzabB;
    private String zzaaN;
    private String zzaaP;
    private String mName;
    private String zzaaL;
    private int zzabC;
    private JSONObject zzaaU;

    MediaTrack(JSONObject json) throws JSONException {
        this.zzg(json);
    }

    MediaTrack(long id, int type) throws IllegalArgumentException {
        this.clear();
        this.zzUZ = id;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.zzabB = type;
    }

    public long getId() {
        return this.zzUZ;
    }

    public int getType() {
        return this.zzabB;
    }

    public String getContentId() {
        return this.zzaaN;
    }

    public void setContentId(String contentId) {
        this.zzaaN = contentId;
    }

    public String getContentType() {
        return this.zzaaP;
    }

    public void setContentType(String contentType) {
        this.zzaaP = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.zzaaL;
    }

    void setLanguage(String language) {
        this.zzaaL = language;
    }

    public int getSubtype() {
        return this.zzabC;
    }

    void zzbe(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException("invalid subtype " + n);
        }
        if (n != 0 && this.zzabB != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzabC = n;
    }

    public JSONObject getCustomData() {
        return this.zzaaU;
    }

    void setCustomData(JSONObject customData) {
        this.zzaaU = customData;
    }

    private void clear() {
        this.zzUZ = 0L;
        this.zzabB = 0;
        this.zzaaN = null;
        this.mName = null;
        this.zzaaL = null;
        this.zzabC = -1;
        this.zzaaU = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zzg(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.zzUZ = jSONObject.getLong("trackId");
        String string = jSONObject.getString("type");
        if ("TEXT".equals(string)) {
            this.zzabB = 1;
        } else if ("AUDIO".equals(string)) {
            this.zzabB = 2;
        } else {
            if (!"VIDEO".equals(string)) throw new JSONException("invalid type: " + string);
            this.zzabB = 3;
        }
        this.zzaaN = jSONObject.optString("trackContentId", null);
        this.zzaaP = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.zzaaL = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string)) {
                this.zzabC = 1;
            } else if ("CAPTIONS".equals(string)) {
                this.zzabC = 2;
            } else if ("DESCRIPTIONS".equals(string)) {
                this.zzabC = 3;
            } else if ("CHAPTERS".equals(string)) {
                this.zzabC = 4;
            } else {
                if (!"METADATA".equals(string)) throw new JSONException("invalid subtype: " + string);
                this.zzabC = 5;
            }
        } else {
            this.zzabC = 0;
        }
        this.zzaaU = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzUZ);
            switch (this.zzabB) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.zzaaN != null) {
                jSONObject.put("trackContentId", (Object)this.zzaaN);
            }
            if (this.zzaaP != null) {
                jSONObject.put("trackContentType", (Object)this.zzaaP);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzaaL)) {
                jSONObject.put("language", (Object)this.zzaaL);
            }
            switch (this.zzabC) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.zzaaU != null) {
                jSONObject.put("customData", (Object)this.zzaaU);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.zzaaU == null != (mediaTrack.zzaaU == null)) {
            return false;
        }
        if (this.zzaaU != null && mediaTrack.zzaaU != null && !zznb.zze((Object)this.zzaaU, (Object)mediaTrack.zzaaU)) {
            return false;
        }
        return this.zzUZ == mediaTrack.zzUZ && this.zzabB == mediaTrack.zzabB && zzf.zza(this.zzaaN, mediaTrack.zzaaN) && zzf.zza(this.zzaaP, mediaTrack.zzaaP) && zzf.zza(this.mName, mediaTrack.mName) && zzf.zza(this.zzaaL, mediaTrack.zzaaL) && this.zzabC == mediaTrack.zzabC;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzUZ, this.zzabB, this.zzaaN, this.zzaaP, this.mName, this.zzaaL, this.zzabC, this.zzaaU});
    }

    public static class Builder {
        private final MediaTrack zzabD;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.zzabD = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.zzabD.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.zzabD.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.zzabD.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.zzabD.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzabD.setLanguage(zzf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.zzabD.zzbe(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzabD.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.zzabD;
        }
    }
}

