/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.JoinOptions;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.ApplicationStatus;
import com.google.android.gms.cast.internal.DeviceStatus;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzi;
import com.google.android.gms.cast.internal.zzj;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzj;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zze
extends zzj<zzi> {
    private static final zzl zzaaf = new zzl("CastClientImpl");
    private ApplicationMetadata zzadx;
    private final CastDevice zzady;
    private final Cast.Listener zzZP;
    private final Map<String, Cast.MessageReceivedCallback> zzadz;
    private final long zzadA;
    private zzb zzadB;
    private String zzadC;
    private boolean zzabt;
    private boolean zzadD;
    private boolean zzadE;
    private boolean zzadF;
    private double zzabs;
    private int zzadG;
    private int zzadH;
    private final AtomicLong zzadI;
    private String zzadJ;
    private String zzadK;
    private Bundle zzadL;
    private final Map<Long, zza.zzb<Status>> zzadM;
    private zza.zzb<Cast.ApplicationConnectionResult> zzadN;
    private zza.zzb<Status> zzadO;
    private static final Object zzadP = new Object();
    private static final Object zzadQ = new Object();

    public zze(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzady = castDevice;
        this.zzZP = listener;
        this.zzadA = l;
        this.zzadz = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzadI = new AtomicLong(0L);
        this.zzadM = new HashMap<Long, zza.zzb<Status>>();
        this.zzoh();
    }

    private void zzoh() {
        this.zzadF = false;
        this.zzadG = -1;
        this.zzadH = -1;
        this.zzadx = null;
        this.zzadC = null;
        this.zzabs = 0.0;
        this.zzabt = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzaaf.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzadF = true;
            this.zzadD = true;
            this.zzadE = true;
        } else {
            this.zzadF = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzadL = new Bundle();
            this.zzadL.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzaaf.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzadB, this.isConnected());
        zzb zzb2 = this.zzadB;
        this.zzadB = null;
        if (zzb2 == null || zzb2.zzos() == null) {
            zzaaf.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzon();
        try {
            ((zzi)this.zzqJ()).disconnect();
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzaaf.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzoi() {
        if (this.zzadL != null) {
            Bundle bundle = this.zzadL;
            this.zzadL = null;
            return bundle;
        }
        return super.zzoi();
    }

    protected String zzgu() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    protected String zzgv() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzi zzaE(IBinder iBinder) {
        return zzi.zza.zzaF(iBinder);
    }

    protected Bundle zzml() {
        Bundle bundle = new Bundle();
        zzaaf.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzadJ, this.zzadK);
        this.zzady.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzadA);
        this.zzadB = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzadB.asBinder()));
        if (this.zzadJ != null) {
            bundle.putString("last_application_id", this.zzadJ);
            if (this.zzadK != null) {
                bundle.putString("last_session_id", this.zzadK);
            }
        }
        return bundle;
    }

    public void zza(String string2, String string3, zza.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzf.zzch(string2);
        this.zzoo();
        long l = this.zzadI.incrementAndGet();
        try {
            this.zzadM.put(l, zzb2);
            ((zzi)this.zzqJ()).zzb(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.zzadM.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        LaunchOptions launchOptions = new LaunchOptions();
        launchOptions.setRelaunchIfRunning(bl);
        this.zza(string2, launchOptions, zzb2);
    }

    public void zza(String string2, LaunchOptions launchOptions, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        ((zzi)this.zzqJ()).zza(string2, launchOptions);
    }

    public void zza(String string2, String string3, JoinOptions joinOptions, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        if (joinOptions == null) {
            joinOptions = new JoinOptions();
        }
        ((zzi)this.zzqJ()).zza(string2, string3, joinOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zza.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzadP;
        synchronized (object) {
            if (this.zzadN != null) {
                this.zzadN.zzs((Object)new zza(new Status(2002)));
            }
            this.zzadN = zzb2;
        }
    }

    public void zzb(zza.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzqJ()).zzou();
    }

    public void zza(String string2, zza.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzqJ()).zzck(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zza.zzb<Status> zzb2) {
        Object object = zzadQ;
        synchronized (object) {
            if (this.zzadO != null) {
                zzb2.zzs((Object)new Status(2001));
                return;
            }
            this.zzadO = zzb2;
        }
    }

    public void zzoj() throws IllegalStateException, RemoteException {
        ((zzi)this.zzqJ()).zzoj();
    }

    public void zzf(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        ((zzi)this.zzqJ()).zza(d, this.zzabs, this.zzabt);
    }

    public void zzX(boolean bl) throws IllegalStateException, RemoteException {
        ((zzi)this.zzqJ()).zza(bl, this.zzabs, this.zzabt);
    }

    public double zzok() throws IllegalStateException {
        this.zzoo();
        return this.zzabs;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzoo();
        return this.zzabt;
    }

    public int zzol() throws IllegalStateException {
        this.zzoo();
        return this.zzadG;
    }

    public int zzom() throws IllegalStateException {
        this.zzoo();
        return this.zzadH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzf.zzch(string2);
        this.zzcg(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzadz;
            synchronized (map) {
                this.zzadz.put(string2, messageReceivedCallback);
            }
            ((zzi)this.zzqJ()).zzcl(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcg(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzadz;
        synchronized (map) {
            messageReceivedCallback = this.zzadz.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzi)this.zzqJ()).zzcm(string2);
            }
            catch (IllegalStateException illegalStateException) {
                zzaaf.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzoo();
        return this.zzadx;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzoo();
        return this.zzadC;
    }

    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zzon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzon() {
        zzaaf.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzadz;
        synchronized (map) {
            this.zzadz.clear();
        }
    }

    private void zza(DeviceStatus deviceStatus) {
        boolean bl;
        ApplicationMetadata applicationMetadata = deviceStatus.getApplicationMetadata();
        if (!zzf.zza(applicationMetadata, this.zzadx)) {
            this.zzadx = applicationMetadata;
            this.zzZP.onApplicationMetadataChanged(this.zzadx);
        }
        boolean bl2 = false;
        double d = deviceStatus.zzok();
        if (d != Double.NaN && Math.abs(d - this.zzabs) > 1.0E-7) {
            this.zzabs = d;
            bl2 = true;
        }
        if ((bl = deviceStatus.zzot()) != this.zzabt) {
            this.zzabt = bl;
            bl2 = true;
        }
        zzaaf.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzadE);
        if (this.zzZP != null && (bl2 || this.zzadE)) {
            this.zzZP.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = deviceStatus.zzol();
        if (n != this.zzadG) {
            this.zzadG = n;
            bl3 = true;
        }
        zzaaf.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzadE);
        if (this.zzZP != null && (bl3 || this.zzadE)) {
            this.zzZP.onActiveInputStateChanged(this.zzadG);
        }
        boolean bl4 = false;
        int n2 = deviceStatus.zzom();
        if (n2 != this.zzadH) {
            this.zzadH = n2;
            bl4 = true;
        }
        zzaaf.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzadE);
        if (this.zzZP != null && (bl4 || this.zzadE)) {
            this.zzZP.onStandbyStateChanged(this.zzadH);
        }
        this.zzadE = false;
    }

    private void zza(ApplicationStatus applicationStatus) {
        boolean bl = false;
        String string2 = applicationStatus.zzoe();
        if (!zzf.zza(string2, this.zzadC)) {
            this.zzadC = string2;
            bl = true;
        }
        zzaaf.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzadD);
        if (this.zzZP != null && (bl || this.zzadD)) {
            this.zzZP.onApplicationStatusChanged();
        }
        this.zzadD = false;
    }

    private void zzoo() throws IllegalStateException {
        if (!this.zzadF || this.zzadB == null || this.zzadB.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzaE(iBinder);
    }

    private static class zzb
    extends zzj.zza {
        private final AtomicReference<zze> zzadU;
        private final Handler mHandler;

        public zzb(zze zze2) {
            this.zzadU = new AtomicReference<zze>(zze2);
            this.mHandler = new Handler(zze2.getLooper());
        }

        public zze zzos() {
            zze zze2 = this.zzadU.getAndSet(null);
            if (zze2 == null) {
                return null;
            }
            zze2.zzoh();
            return zze2;
        }

        public boolean isDisposed() {
            return this.zzadU.get() == null;
        }

        @Override
        public void zzbk(int n) {
            zze zze2 = this.zzos();
            if (zze2 == null) {
                return;
            }
            zzaaf.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zze2.zzbS(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzadx = applicationMetadata;
            zze2.zzadJ = applicationMetadata.getApplicationId();
            zze2.zzadK = string3;
            Object object = zzadP;
            synchronized (object) {
                if (zze2.zzadN != null) {
                    zze2.zzadN.zzs((Object)new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zze2.zzadN = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbl(int n) {
            zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            Object object = zzadP;
            synchronized (object) {
                if (zze2.zzadN != null) {
                    zze2.zzadN.zzs((Object)new zza(new Status(n)));
                    zze2.zzadN = null;
                }
            }
        }

        @Override
        public void zzbm(int n) {
            zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void zzbn(int n) {
            zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void onApplicationDisconnected(final int statusCode) {
            final zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzadJ = null;
            zze2.zzadK = null;
            this.zza(zze2, statusCode);
            if (zze2.zzZP != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zze2.zzZP.onApplicationDisconnected(statusCode);
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            zzaaf.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final DeviceStatus deviceStatus) {
            final zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            zzaaf.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(deviceStatus);
                }
            });
        }

        @Override
        public void zzb(final ApplicationStatus applicationStatus) {
            final zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            zzaaf.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(applicationStatus);
                }
            });
        }

        @Override
        public void zzt(final String string2, final String string3) {
            final zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            zzaaf.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zze2.zzadz;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zze2.zzadz.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zze2.zzady, string2, string3);
                    } else {
                        zzaaf.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            zzaaf.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, n);
        }

        @Override
        public void zzc(String string2, long l) {
            zze zze2 = this.zzadU.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zze zze2, long l, int n) {
            zza.zzb zzb2;
            Map map = zze2.zzadM;
            synchronized (map) {
                zzb2 = (zza.zzb)zze2.zzadM.remove(l);
            }
            if (zzb2 != null) {
                zzb2.zzs((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zze zze2, int n) {
            Object object = zzadQ;
            synchronized (object) {
                if (zze2.zzadO != null) {
                    zze2.zzadO.zzs((Object)new Status(n));
                    zze2.zzadO = null;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzUX;
        private final ApplicationMetadata zzadR;
        private final String zzadS;
        private final String zzLq;
        private final boolean zzadT;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.zzUX = status;
            this.zzadR = applicationMetadata;
            this.zzadS = string2;
            this.zzLq = string3;
            this.zzadT = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzadR;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzadS;
        }

        @Override
        public String getSessionId() {
            return this.zzLq;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzadT;
        }
    }
}

