/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.SessionInsertRequest;
import com.google.android.gms.fitness.request.SessionReadRequest;
import com.google.android.gms.fitness.result.SessionReadResult;
import com.google.android.gms.fitness.result.SessionStopResult;

public interface SessionsApi {
    public PendingResult<Status> startSession(GoogleApiClient var1, Session var2);

    public PendingResult<SessionStopResult> stopSession(GoogleApiClient var1, String var2);

    public PendingResult<Status> insertSession(GoogleApiClient var1, SessionInsertRequest var2);

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<SessionReadResult> readSession(GoogleApiClient var1, SessionReadRequest var2);

    public PendingResult<Status> registerForSessions(GoogleApiClient var1, PendingIntent var2);

    public PendingResult<Status> unregisterForSessions(GoogleApiClient var1, PendingIntent var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private Session zzavX;
        private String zzavW;
        private boolean zzavY = false;

        public ViewIntentBuilder(Context context) {
            this.mContext = context;
        }

        public ViewIntentBuilder setSession(Session session) {
            this.zzavX = session;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.zzavW = packageName;
            this.zzavY = true;
            return this;
        }

        public Intent build() {
            zzx.zza((this.zzavX != null ? 1 : 0) != 0, (Object)"Session must be set");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(Session.getMimeType(this.zzavX.getActivity()));
            zzc.zza((SafeParcelable)this.zzavX, (Intent)intent, (String)"vnd.google.fitness.session");
            if (!this.zzavY) {
                this.zzavW = this.zzavX.getAppPackageName();
            }
            return this.zzl(intent);
        }

        private Intent zzl(Intent intent) {
            if (this.zzavW == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzavW);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzavW, string));
                return intent2;
            }
            return intent;
        }
    }
}

