/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzs;

public class Subscription
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzavU;
    private final DataType zzavT;
    private final long zzaxo;
    private final int zzaxp;
    public static final Parcelable.Creator<Subscription> CREATOR = new zzs();

    Subscription(int versionCode, DataSource dataSource, DataType dataType, long samplingIntervalMicros, int accuracyMode) {
        this.mVersionCode = versionCode;
        this.zzavU = dataSource;
        this.zzavT = dataType;
        this.zzaxo = samplingIntervalMicros;
        this.zzaxp = accuracyMode;
    }

    private Subscription(zza builder) {
        this.mVersionCode = 1;
        this.zzavT = builder.zzavT;
        this.zzavU = builder.zzavU;
        this.zzaxo = builder.zzaxo;
        this.zzaxp = builder.zzaxp;
    }

    public DataSource getDataSource() {
        return this.zzavU;
    }

    public DataType getDataType() {
        return this.zzavT;
    }

    public int getAccuracyMode() {
        return this.zzaxp;
    }

    public long zzux() {
        return this.zzaxo;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Subscription && this.zza((Subscription)that);
    }

    private boolean zza(Subscription subscription) {
        return zzw.equal((Object)this.zzavU, (Object)subscription.zzavU) && zzw.equal((Object)this.zzavT, (Object)subscription.zzavT) && this.zzaxo == subscription.zzaxo && this.zzaxp == subscription.zzaxp;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavU, this.zzavU, this.zzaxo, this.zzaxp});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("dataSource", (Object)this.zzavU).zzg("dataType", (Object)this.zzavT).zzg("samplingIntervalMicros", (Object)this.zzaxo).zzg("accuracyMode", (Object)this.zzaxp).toString();
    }

    public String toDebugString() {
        return String.format("Subscription{%s}", this.zzavU == null ? this.zzavT.getName() : this.zzavU.toDebugString());
    }

    public DataType zzuy() {
        return this.zzavT == null ? this.zzavU.getDataType() : this.zzavT;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzs.zza(this, dest, flags);
    }

    public static class zza {
        private DataSource zzavU;
        private DataType zzavT;
        private long zzaxo = -1L;
        private int zzaxp = 2;

        public zza zzb(DataSource dataSource) {
            this.zzavU = dataSource;
            return this;
        }

        public zza zzb(DataType dataType) {
            this.zzavT = dataType;
            return this;
        }

        public Subscription zzuz() {
            zzx.zza((this.zzavU != null || this.zzavT != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzavT == null || this.zzavU == null || this.zzavT.equals(this.zzavU.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new Subscription(this);
        }
    }
}

