/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzx;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final Session zzavX;
    private final List<DataSet> zzawg;
    private final List<DataPoint> zzaBs;
    private final zzow zzaAD;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzx();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzavX = session;
        this.zzawg = Collections.unmodifiableList(dataSets);
        this.zzaBs = Collections.unmodifiableList(aggregateDataPoints);
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzavX, builder.zzawg, builder.zzaBs, null);
    }

    public SessionInsertRequest(SessionInsertRequest request, zzow callback) {
        this(request.zzavX, request.zzawg, request.zzaBs, callback);
    }

    public SessionInsertRequest(Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, zzow callback) {
        this.mVersionCode = 3;
        this.zzavX = session;
        this.zzawg = Collections.unmodifiableList(dataSets);
        this.zzaBs = Collections.unmodifiableList(aggregateDataPoints);
        this.zzaAD = callback;
    }

    public Session getSession() {
        return this.zzavX;
    }

    public List<DataSet> getDataSets() {
        return this.zzawg;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzaBs;
    }

    public IBinder getCallbackBinder() {
        return this.zzaAD == null ? null : this.zzaAD.asBinder();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)o);
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzw.equal((Object)this.zzavX, (Object)sessionInsertRequest.zzavX) && zzw.equal(this.zzawg, sessionInsertRequest.zzawg) && zzw.equal(this.zzaBs, sessionInsertRequest.zzaBs);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavX, this.zzawg, this.zzaBs});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("session", (Object)this.zzavX).zzg("dataSets", this.zzawg).zzg("aggregateDataPoints", this.zzaBs).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzx.zza(this, dest, flags);
    }

    public static class Builder {
        private Session zzavX;
        private List<DataSet> zzawg = new ArrayList<DataSet>();
        private List<DataPoint> zzaBs = new ArrayList<DataPoint>();
        private List<DataSource> zzaBt = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzavX = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            com.google.android.gms.common.internal.zzx.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            com.google.android.gms.common.internal.zzx.zza((!this.zzaBt.contains(dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            com.google.android.gms.common.internal.zzx.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzaBt.add(dataSource);
            this.zzawg.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            com.google.android.gms.common.internal.zzx.zzb((aggregateDataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = aggregateDataPoint.getDataSource();
            com.google.android.gms.common.internal.zzx.zza((!this.zzaBt.contains(dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            zznw.zze(aggregateDataPoint);
            this.zzaBt.add(dataSource);
            this.zzaBs.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            com.google.android.gms.common.internal.zzx.zza((this.zzavX != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            com.google.android.gms.common.internal.zzx.zza((this.zzavX.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzvd();
            return new SessionInsertRequest(this);
        }

        private void zzf(DataPoint dataPoint) {
            this.zzh(dataPoint);
            this.zzg(dataPoint);
        }

        private void zzg(DataPoint dataPoint) {
            long l = this.zzavX.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzavX.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzns.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                com.google.android.gms.common.internal.zzx.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzh(DataPoint dataPoint) {
            long l = this.zzavX.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzavX.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzns.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                com.google.android.gms.common.internal.zzx.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzvd() {
            for (DataSet object : this.zzawg) {
                for (DataPoint dataPoint : object.getDataPoints()) {
                    this.zzf(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzaBs) {
                this.zzf(dataPoint);
            }
        }
    }
}

