/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzad;
import com.google.android.gms.fitness.request.zzq;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzow;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzawe;
    private final zzq zzaBA;
    private final int zzaBB;
    private final zzow zzaAD;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzad();

    StartBleScanRequest(int versionCode, List<DataType> dataTypes, IBinder bleScanCallback, int timeoutSecs, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzawe = dataTypes;
        this.zzaBA = zzq.zza.zzbU(bleScanCallback);
        this.zzaBB = timeoutSecs;
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    private StartBleScanRequest(Builder builder) {
        this(zzmn.zzb((Object[])builder.zzaAY), builder.zzaBA, builder.zzaBB, null);
    }

    public StartBleScanRequest(StartBleScanRequest request, zzow callback) {
        this(request.zzawe, request.zzaBA, request.zzaBB, callback);
    }

    public StartBleScanRequest(List<DataType> dataTypes, zzq bleScanCallback, int timeoutSecs, zzow callback) {
        this.mVersionCode = 4;
        this.zzawe = dataTypes;
        this.zzaBA = bleScanCallback;
        this.zzaBB = timeoutSecs;
        this.zzaAD = callback;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzawe);
    }

    public int getTimeoutSecs() {
        return this.zzaBB;
    }

    public IBinder zzvg() {
        return this.zzaBA.asBinder();
    }

    public IBinder getCallbackBinder() {
        return this.zzaAD == null ? null : this.zzaAD.asBinder();
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("dataTypes", this.zzawe).zzg("timeoutSecs", (Object)this.zzaBB).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzad.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzaAY = new DataType[0];
        private zzq zzaBA;
        private int zzaBB = 10;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzaAY = dataTypes;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzuJ().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzq zzq2) {
            this.zzaBA = zzq2;
            return this;
        }

        public Builder setTimeoutSecs(int stopTimeSecs) {
            zzx.zzb((stopTimeSecs > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzx.zzb((stopTimeSecs <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzaBB = stopTimeSecs;
            return this;
        }

        public StartBleScanRequest build() {
            zzx.zza((this.zzaBA != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

