/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zznx;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class zznw {
    private static final Set<String> zzazD = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(zznt.zzaxI.name, zznt.zzaxW.name)));

    public static String zzd(DataPoint dataPoint) {
        DataType dataType = dataPoint.getDataType();
        if (!zznu.zzdD(dataType.getName())) {
            return null;
        }
        for (Field field : dataType.getFields()) {
            double d;
            Value value = dataPoint.getValue(field);
            if (!value.isSet()) {
                if (zzazD.contains(field.getName())) continue;
                return field.getName() + " not set";
            }
            if (field.getFormat() == 1) {
                d = value.asInt();
            } else {
                if (field.getFormat() != 2) continue;
                d = value.asFloat();
            }
            zznx.zza zza2 = zznx.zzuG().zzdE(field.getName());
            if (zza2 != null && !zza2.zzh(d)) {
                return "Field out of range";
            }
            zza2 = zznx.zzuG().zzC(dataType.getName(), field.getName());
            if (zza2 == null) continue;
            long l = dataPoint.getTimestampNanos() - dataPoint.zzuj();
            if (l == 0L) {
                if (d == 0.0) {
                    return null;
                }
                return "DataPoint out of range";
            }
            double d2 = d / (double)l;
            if (zza2.zzh(d2)) continue;
            return "DataPoint out of range";
        }
        return null;
    }

    public static void zze(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zznw.zzd(dataPoint);
        if (string != null) {
            Log.w((String)"Fitness", (String)("Invalid data point: " + dataPoint));
            throw new IllegalArgumentException(string);
        }
    }
}

